/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.mail;

import javax.mail.Multipart;
import org.silverpeas.mail.MailAddress;
import org.silverpeas.mail.MailContent;
import org.silverpeas.mail.MailToSend;
import org.silverpeas.mail.ReceiverMailAddressSet;
import org.silverpeas.mail.engine.MailSenderThread;

public class MailSending {
    private MailToSend mailToSend;

    public static MailSending from(MailAddress senderEmail) {
        MailSending mailSending = new MailSending();
        mailSending.mailToSend = new MailToSend();
        mailSending.mailToSend.setFrom(senderEmail);
        return mailSending;
    }

    private MailSending() {
    }

    public MailSending to(MailAddress receiverMailAddress) {
        this.mailToSend.setTo(ReceiverMailAddressSet.with(receiverMailAddress));
        return this;
    }

    public MailSending to(ReceiverMailAddressSet receiverMailAddressSet) {
        this.mailToSend.setTo(receiverMailAddressSet);
        return this;
    }

    public MailSending withSubject(String subject) {
        this.mailToSend.setSubject(subject);
        return this;
    }

    public MailSending withContent(String content) {
        this.mailToSend.setContent(MailContent.of(content));
        return this;
    }

    public MailSending withTextContent(String content) {
        this.mailToSend.setContent(MailContent.of(content).notHtml());
        return this;
    }

    public MailSending withContent(Multipart content) {
        this.mailToSend.setContent(MailContent.of(content));
        return this;
    }

    public MailSending withContent(MailContent content) {
        this.mailToSend.setContent(content);
        return this;
    }

    public MailSending setReplyToRequired() {
        this.mailToSend.setReplyToRequired();
        return this;
    }

    MailToSend getMailToSend() {
        return this.mailToSend;
    }

    public void send() {
        MailSenderThread.addMailToSend(this.mailToSend);
    }

    public void sendSynchronously() {
        this.mailToSend.sendSynchronously();
        this.send();
    }
}

