/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.mail.engine;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.silverpeas.mail.MailAddress;
import org.silverpeas.mail.MailToSend;
import org.silverpeas.mail.ReceiverMailAddressSet;
import org.silverpeas.mail.engine.MailSender;
import org.silverpeas.mail.engine.SmtpConfiguration;
import org.silverpeas.mail.engine.SmtpMailSendReportListener;
import org.silverpeas.util.Charsets;

public class SmtpMailSender
implements MailSender {
    private Session getMailSession(SmtpConfiguration smtpConfiguration) {
        Properties properties = System.getProperties();
        properties.put("mail.smtp.host", smtpConfiguration.getServer());
        properties.put("mail.smtp.auth", String.valueOf(smtpConfiguration.isAuthenticate()));
        Session session = Session.getInstance((Properties)properties, null);
        session.setDebug(smtpConfiguration.isDebug());
        return session;
    }

    @Override
    public void send(MailToSend mail) {
        SmtpConfiguration smtpConfiguration = SmtpConfiguration.fromDefaultSettings();
        MailAddress fromMailAddress = mail.getFrom();
        Session session = this.getMailSession(smtpConfiguration);
        try {
            InternetAddress fromAddress = fromMailAddress.getAuthorizedInternetAddress();
            InternetAddress replyToAddress = null;
            ArrayList<InternetAddress[]> toAddresses = new ArrayList<InternetAddress[]>();
            List<ReceiverMailAddressSet> addressBatches = mail.getTo().getBatchedReceiversList();
            for (ReceiverMailAddressSet addressBatch : addressBatches) {
                try {
                    toAddresses.add(InternetAddress.parse((String)addressBatch.getEmailsSeparatedByComma(), (boolean)false));
                }
                catch (AddressException e) {
                    SilverTrace.warn("mail", "MailSender.send()", "root.MSG_GEN_PARAM_VALUE", "From = " + fromMailAddress + ", To = " + addressBatch.getEmailsSeparatedByComma(), e);
                }
            }
            try {
                if (mail.isReplyToRequired()) {
                    replyToAddress = new InternetAddress(fromMailAddress.getEmail(), false);
                    if (StringUtil.isDefined(fromMailAddress.getName())) {
                        replyToAddress.setPersonal(fromMailAddress.getName(), Charsets.UTF_8.name());
                    }
                }
            }
            catch (AddressException e) {
                SilverTrace.warn("mail", "MailSender.send()", "root.MSG_GEN_PARAM_VALUE", "ReplyTo = " + fromMailAddress + " is malformed.", e);
            }
            MimeMessage email = new MimeMessage(session);
            email.setFrom((Address)fromAddress);
            if (replyToAddress != null) {
                email.setReplyTo((Address[])new InternetAddress[]{replyToAddress});
            }
            email.setHeader("Precedence", "list");
            email.setHeader("List-ID", fromAddress.getAddress());
            email.setSentDate(new Date());
            email.setSubject(mail.getSubject(), "UTF-8");
            mail.getContent().applyOn(email);
            this.performSend(mail, smtpConfiguration, session, email, toAddresses);
        }
        catch (MessagingException e) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSend(MailToSend mail, SmtpConfiguration smtpConfiguration, Session session, MimeMessage messageToSend, List<InternetAddress[]> batchedToAddresses) throws MessagingException {
        Transport transport = smtpConfiguration.isSecure() ? session.getTransport("smtps") : session.getTransport("smtp");
        transport.addTransportListener((TransportListener)new SmtpMailSendReportListener(mail));
        try {
            if (smtpConfiguration.isAuthenticate()) {
                SilverTrace.info("mail", "SmtpMailSender.send()", "root.MSG_GEN_PARAM_VALUE", "Host = " + smtpConfiguration.getServer() + " Port=" + smtpConfiguration.getPort() + " User=" + smtpConfiguration.getUsername());
                transport.connect(smtpConfiguration.getServer(), smtpConfiguration.getPort(), smtpConfiguration.getUsername(), smtpConfiguration.getPassword());
            } else {
                transport.connect(smtpConfiguration.getServer(), smtpConfiguration.getPort(), null, null);
            }
            for (InternetAddress[] toAddressBatch : batchedToAddresses) {
                messageToSend.setRecipients(mail.getTo().getRecipientType().getTechnicalType(), (Address[])toAddressBatch);
                transport.sendMessage((Message)messageToSend, (Address[])toAddressBatch);
            }
        }
        finally {
            try {
                transport.close();
            }
            catch (Exception e) {
                SilverTrace.error("mail", "SmtpMailSender.send()", "root.EX_IGNORED", "ClosingTransport", e);
            }
        }
    }
}

