/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.notification.jsondiff;

import java.io.Serializable;
import org.silverpeas.notification.jsondiff.Op;

public class Operation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Op op;
    private String path;
    private String value;

    public Operation() {
    }

    public Operation(Op type, String path, String value) {
        this.op = type;
        this.path = path;
        this.value = value;
    }

    public void setOp(Op type) {
        this.op = type;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Op getOp() {
        return this.op;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.op != null ? this.op.hashCode() : 0);
        hash = 59 * hash + (this.path != null ? this.path.hashCode() : 0);
        hash = 59 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operation other = (Operation)obj;
        if (this.op != other.op) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "Operation{op=" + (Object)((Object)this.op) + ", path=" + this.path + ", value=" + this.value + '}';
    }

    public static Operation determineOperation(String path, String oldValue, String newValue) {
        if (oldValue == null && newValue != null) {
            return new Operation(Op.add, path, newValue);
        }
        if (oldValue != null && newValue == null) {
            return new Operation(Op.remove, path, "");
        }
        if (oldValue == null && newValue == null || oldValue.equals(newValue)) {
            return new Operation(Op.none, path, newValue);
        }
        return new Operation(Op.replace, path, newValue);
    }
}

