/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.persistence.model.jpa;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.silverpeas.date.Period;
import org.silverpeas.persistence.model.Entity;
import org.silverpeas.persistence.model.EntityIdentifier;
import org.silverpeas.persistence.model.jpa.AbstractJpaEntity;

@MappedSuperclass
public abstract class AbstractPeriodDateAsLongJpaEntity<ENTITY extends Entity<ENTITY, IDENTIFIER_TYPE>, IDENTIFIER_TYPE extends EntityIdentifier>
extends AbstractJpaEntity<ENTITY, IDENTIFIER_TYPE> {
    @Column(name="beginDate", nullable=false)
    private Long beginDate;
    @Column(name="endDate", nullable=false)
    private Long endDate;
    @Transient
    private Period period;

    public Period getPeriod() {
        if (this.beginDate != null && this.endDate != null) {
            if (this.period == null) {
                this.period = Period.from(new Date(this.beginDate), new Date(this.endDate));
            }
        } else {
            this.period = null;
        }
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
        this.beginDate = period.getBeginDate().getTime();
        this.endDate = period.getEndDate().getTime();
    }
}

