/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.analysis;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.silverpeas.search.indexEngine.analysis.SilverTokenizerImpl;

public class SilverTokenizer
extends Tokenizer {
    private SilverTokenizerImpl scanner;
    private boolean replaceInvalidAcronym;
    private int maxTokenLength = 255;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public SilverTokenizer(Reader input2) {
        super(input2);
        this.init();
    }

    public SilverTokenizer(AttributeSource source, Reader input2) {
        super(source, input2);
        this.init();
    }

    public SilverTokenizer(AttributeSource.AttributeFactory factory, Reader input2) {
        super(factory, input2);
        this.init();
    }

    private void init() {
        this.scanner = new SilverTokenizerImpl(this.input);
        this.replaceInvalidAcronym = false;
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        int posIncr = 1;
        while (true) {
            int tokenType = -1;
            try {
                tokenType = this.scanner.getNextToken();
            }
            catch (Error e) {
                SilverTrace.error("indexEngine", "SilverTokenizer.incrementToken", "root.MSG_GEN_PARAM_VALUE", "Error while tokenizing content : " + e.getMessage());
                return false;
            }
            if (tokenType == -1) {
                return false;
            }
            if (this.scanner.yylength() <= this.maxTokenLength) {
                this.posIncrAtt.setPositionIncrement(posIncr);
                this.scanner.getText(this.termAtt);
                int start = this.scanner.yychar();
                this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(start + this.termAtt.length()));
                if (tokenType == 8) {
                    if (this.replaceInvalidAcronym) {
                        this.typeAtt.setType(SilverTokenizerImpl.TOKEN_TYPES[5]);
                        this.termAtt.setLength(this.termAtt.length() - 1);
                    } else {
                        this.typeAtt.setType(SilverTokenizerImpl.TOKEN_TYPES[2]);
                    }
                } else {
                    this.typeAtt.setType(SilverTokenizerImpl.TOKEN_TYPES[tokenType]);
                }
                return true;
            }
            ++posIncr;
        }
    }

    public final void end() {
        int finalOffset = this.correctOffset(this.scanner.yychar() + this.scanner.yylength());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public void reset(Reader reader) throws IOException {
        super.reset(reader);
        this.scanner.yyreset(reader);
    }

    @Deprecated
    public boolean isReplaceInvalidAcronym() {
        return this.replaceInvalidAcronym;
    }

    @Deprecated
    public void setReplaceInvalidAcronym(boolean replaceInvalidAcronym) {
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }
}

