/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class IndexReadersCache {
    private static final IndexReadersCache instance = new IndexReadersCache();
    private Map<String, IndexReader> indexReaders = new HashMap<String, IndexReader>();

    private IndexReadersCache() {
    }

    private static IndexReadersCache getInstance() {
        return instance;
    }

    public static synchronized IndexReader getIndexReader(String path) {
        if (!IndexReadersCache.getInstance().indexReaders.containsKey(path)) {
            try {
                IndexReadersCache.getInstance().indexReaders.put(path, IndexReader.open((Directory)FSDirectory.open((File)new File(path))));
            }
            catch (Exception e) {
                SilverTrace.warn("searchEngine", "IndexManager.getIndexReader()", "searchEngine.MSG_CANT_OPEN_INDEX_SEARCHER", e);
            }
        }
        return IndexReadersCache.getInstance().indexReaders.get(path);
    }

    public static synchronized void removeIndexReader(String path) {
        if (IndexReadersCache.getInstance().indexReaders.containsKey(path)) {
            IndexReader indexReader = IndexReadersCache.getInstance().indexReaders.get(path);
            try {
                indexReader.close();
            }
            catch (IOException e) {
                SilverTrace.warn("indexEngine", "IndexManager.removeIndexReader", "indexEngine.MSG_CANT_CLOSE_INDEX_SEARCHER", path, e);
            }
            IndexReadersCache.getInstance().indexReaders.remove(path);
        }
    }
}

