/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.parser.ooParser;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.silverpeas.search.indexEngine.parser.Parser;

public class OOParser
implements Parser {
    private String tempFolder = null;
    private final String TMP_UNZIP_DIR = "tmpUnzipOpenOffice";
    private final Namespace NS_OO = Namespace.getNamespace((String)"office", (String)"urn:oasis:names:tc:opendocument:xmlns:office:1.0");
    public final Namespace NS_DC = Namespace.getNamespace((String)"dc", (String)"http://purl.org/dc/elements/1.1/");
    private final Namespace NS_OOMETA = Namespace.getNamespace((String)"meta", (String)"urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
    private final Namespace NS_OOTEXT = Namespace.getNamespace((String)"text", (String)"urn:oasis:names:tc:opendocument:xmlns:text:1.0");
    private final String TITLE = "title";
    private final String SUBJECT = "subject";
    private final String DESCRIPTION = "description";
    private final String INITIAL_CREATOR = "initial-creator";
    private final String KEYWORD = "keyword";
    private final String contentFile = "content.xml";
    private final String metaFile = "meta.xml";

    @Override
    public Reader getReader(String path, String encoding) {
        StringReader reader = null;
        this.tempFolder = Long.toString(System.currentTimeMillis());
        try {
            List<String> toIndex = this.getFilesToIndex(path);
            String ooContents = this.parse(toIndex);
            this.deleteDir(new File(FileRepositoryManager.getTemporaryPath() + "tmpUnzipOpenOffice" + File.separator + this.tempFolder));
            reader = new StringReader(ooContents);
        }
        catch (Exception e) {
            SilverTrace.error("indexEngine", "OOParser.getReader()", "indexEngine.MSG_IO_ERROR_WHILE_READING", path, e);
        }
        return reader;
    }

    public String parse(Object file) {
        SilverTrace.debug("indexEngine", "OOParser.parse()", "root.MSG_PARAM_VALUE", "file=" + file.toString());
        StringBuilder parsingResult = new StringBuilder();
        try {
            List children;
            List files = (List)file;
            SAXBuilder builder = new SAXBuilder();
            builder.setValidation(false);
            SilverTrace.debug("indexEngine", "OOParser.parse()()", "root.MSG_PARAM_VALUE", "file0 = " + files.get(0));
            SilverTrace.debug("indexEngine", "OOParser.parse()()", "root.MSG_PARAM_VALUE", "file1 = " + files.get(1));
            Document xmlDocContent = builder.build(new File((String)files.get(0)));
            Document xmlMeta = builder.build(new File((String)files.get(1)));
            Element body = xmlDocContent.getRootElement().getChild("body", this.NS_OO);
            if (body != null) {
                Iterator childrenElements = body.getDescendants((Filter)new ElementFilter(this.NS_OOTEXT));
                while (childrenElements.hasNext()) {
                    Element currentElement = (Element)childrenElements.next();
                    SilverTrace.debug("indexEngine", "OOParser.parse()", "Current Element = " + currentElement.getName() + " - " + currentElement.getText());
                    parsingResult.append(' ').append(currentElement.getText());
                }
            }
            if ((children = xmlMeta.getRootElement().getChildren()) != null) {
                for (Object aChildren : children) {
                    Element currentElement = (Element)aChildren;
                    if (currentElement.getChild("title", this.NS_DC) != null) {
                        parsingResult.append(' ').append(currentElement.getChild("title", this.NS_DC).getText());
                    }
                    if (currentElement.getChild("subject", this.NS_DC) != null) {
                        parsingResult.append(' ').append(currentElement.getChild("subject", this.NS_DC).getText());
                    }
                    if (currentElement.getChild("description", this.NS_DC) != null) {
                        parsingResult.append(" ").append(currentElement.getChild("description", this.NS_DC).getText());
                    }
                    if (currentElement.getChild("initial-creator", this.NS_OOMETA) != null) {
                        parsingResult.append(' ').append(currentElement.getChild("initial-creator", this.NS_OOMETA).getText());
                    }
                    if (currentElement.getChild("keyword", this.NS_OOMETA) == null) continue;
                    parsingResult.append(' ').append(currentElement.getChild("keyword", this.NS_OOMETA).getText());
                }
            }
        }
        catch (JDOMException e) {
            SilverTrace.error("indexEngine", "OOParser.parse", "indexEngine.MSG_IO_ERROR_WHILE_PARSING", e);
            this.deleteTmp((File)file);
        }
        catch (IOException e) {
            SilverTrace.error("indexEngine", "OOParser.parse", "indexEngine.MSG_IO_ERROR_WHILE_PARSING", e);
            this.deleteTmp((File)file);
        }
        SilverTrace.debug("indexEngine", "OOParser.parse()", "parsingResult = " + parsingResult.toString());
        return parsingResult.toString();
    }

    private List<String> getFilesToIndex(String file) {
        String dest = FileRepositoryManager.getTemporaryPath() + "tmpUnzipOpenOffice" + File.separator + this.tempFolder;
        this.unzip(file, dest);
        ArrayList<String> ls = new ArrayList<String>();
        ls.add(0, dest + File.separator + "content.xml");
        ls.add(1, dest + File.separator + "meta.xml");
        return ls;
    }

    private List<String> unzip(String zip, String destination) {
        SilverTrace.debug("indexEngine", "OOParser.unzip()()", "root.MSG_PARAM_VALUE", "zip = " + zip + " destination=" + destination);
        ArrayList<String> destLs = new ArrayList<String>();
        File dest = new File(destination);
        try {
            SilverTrace.debug("indexEngine", "OOParser.unzip()()", "root.MSG_PARAM_VALUE", "tempFolder = " + this.tempFolder);
            dest.mkdirs();
            if (dest.isDirectory()) {
                ZipFile zipFile = new ZipFile(zip);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equals("meta.xml") && !entry.getName().equals("content.xml")) continue;
                    this.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(dest + File.separator + entry.getName())));
                    destLs.add(dest.getAbsolutePath() + File.separator + entry.getName());
                }
                zipFile.close();
            } else {
                SilverTrace.error("indexEngine", "OOParser.unzip", "indexEngine.MSG_IO_ERROR_WHILE_READING", dest.getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.deleteDir(new File(destination));
            SilverTrace.error("indexEngine", "OOParser.unzip", "indexEngine.MSG_IO_ERROR_WHILE_EXTRACTING", zip, e);
        }
        catch (Exception e) {
            this.deleteDir(new File(destination));
            SilverTrace.error("indexEngine", "OOParser.unzip", "indexEngine.MSG_IO_ERROR_WHILE_EXTRACTING", zip, e);
        }
        return destLs;
    }

    private void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                boolean success = this.deleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    protected void deleteTmp(File file) {
        String dir = FileRepositoryManager.getTemporaryPath() + "tmpUnzipOpenOffice" + File.separator + this.tempFolder + File.separator + file;
        this.deleteDir(new File(dir));
    }
}

