/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.searchEngine.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.search.indexEngine.model.IndexEntry;
import org.silverpeas.search.indexEngine.model.IndexEntryPK;

public class MatchingIndexEntry
extends IndexEntry
implements Serializable {
    private List<String> embeddedFileIds;
    private Map<String, String> sortableXMLFormFields = null;
    private Map<String, String> xmlFormFieldsForFacet = null;
    private static final long serialVersionUID = 5931254295396221458L;
    private static final String CHARACTER_ENCODING = "UTF-8";
    private float score = 0.0f;

    public MatchingIndexEntry(String space, String component, String objectType, String objectId) {
        super(component, objectType, objectId);
    }

    public MatchingIndexEntry(IndexEntryPK pk) {
        super(pk);
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public String getPageAndParams() {
        String type = "";
        String id = "";
        try {
            type = URLEncoder.encode(this.getObjectType(), CHARACTER_ENCODING);
            id = URLEncoder.encode(this.getObjectId(), CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            SilverTrace.error("SearchEngine", "MatchingIndexEntry.getPageAndParams()", "Unsupported encoding", e);
        }
        return "searchResult?Type=" + type + "&Id=" + id;
    }

    public String getParams() {
        String id = "";
        try {
            id = URLEncoder.encode(this.getObjectId(), CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            SilverTrace.error("SearchEngine", "MatchingIndexEntry.getParams()", "Unsupported encoding", e);
        }
        return "documentId%3d" + id;
    }

    public Map<String, String> getSortableXMLFormFields() {
        return this.sortableXMLFormFields;
    }

    public void setSortableXMLFormFields(HashMap<String, String> sortableXMLFormFields) {
        this.sortableXMLFormFields = sortableXMLFormFields;
    }

    public void setEmbeddedFileIds(String[] embeddedFileIds) {
        this.embeddedFileIds = embeddedFileIds == null ? new ArrayList<String>() : Arrays.asList((Object[])embeddedFileIds.clone());
    }

    public List<String> getEmbeddedFileIds() {
        return this.embeddedFileIds;
    }

    public void setXMLFormFieldsForFacets(Map<String, String> fields) {
        this.xmlFormFieldsForFacet = fields;
    }

    public Map<String, String> getXMLFormFieldsForFacets() {
        return this.xmlFormFieldsForFacet;
    }
}

