/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.sharing;

import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.silverpeas.attachment.model.SimpleDocument;

public class SharingContext {
    private static Pattern REGEXPR_SHARED_ATTACHMENT = Pattern.compile("(?i)src=\"(.+/attachmentId/[^\"]+)");
    private String baseURI;
    private String token;

    public SharingContext(String baseURI, String token) {
        this.baseURI = baseURI;
        this.token = token;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String applyOn(String text) {
        Matcher matcher;
        String newStr = text;
        while ((matcher = REGEXPR_SHARED_ATTACHMENT.matcher(newStr)).find()) {
            String currentURL = matcher.group(1);
            newStr = matcher.replaceFirst("src=\"" + this.convertURLToSharedOne(currentURL));
        }
        return newStr;
    }

    private String convertURLToSharedOne(String url) {
        Object[] parts = StringUtil.split((String)url, (String)"/");
        Object name = parts[ArrayUtil.indexOf((Object[])parts, (Object)"name") + 1];
        Object id = parts[ArrayUtil.indexOf((Object[])parts, (Object)"attachmentId") + 1];
        Object instanceId = parts[ArrayUtil.indexOf((Object[])parts, (Object)"componentId") + 1];
        return this.getBaseURI() + "sharing/attachments/" + (String)instanceId + "/" + this.getToken() + "/" + (String)id + "/" + (String)name;
    }

    public URI getSharedUriOf(SimpleDocument attachment) {
        URI sharedUri;
        try {
            sharedUri = URI.create(this.getBaseURI() + "sharing/attachments/" + attachment.getInstanceId() + "/" + this.getToken() + "/" + attachment.getId() + "/" + URLEncoder.encode(attachment.getFilename(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(SharingContext.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            Logger.getLogger(SharingContext.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return sharedUri;
    }
}

