/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.token.persistent.service;

import com.silverpeas.annotation.Service;
import javax.inject.Inject;
import org.silverpeas.EntityReference;
import org.silverpeas.token.TokenGenerationParameter;
import org.silverpeas.token.TokenGenerator;
import org.silverpeas.token.TokenGeneratorProvider;
import org.silverpeas.token.exception.TokenException;
import org.silverpeas.token.persistent.PersistentResourceToken;
import org.silverpeas.token.persistent.repository.PersistentResourceTokenRepository;
import org.silverpeas.token.persistent.service.PersistentResourceTokenService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="persistentResourceTokenService")
public class DefaultTokenService
implements PersistentResourceTokenService {
    @Inject
    private PersistentResourceTokenRepository tokenRepository;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public PersistentResourceToken initialize(EntityReference resource) throws TokenException {
        TokenGenerator generator = TokenGeneratorProvider.getTokenGenerator(PersistentResourceToken.class);
        PersistentResourceToken token = this.get(resource);
        token = token.notExists() ? (PersistentResourceToken)generator.generate(TokenGenerationParameter.params("Resource", resource)) : generator.renew(token);
        token.validate();
        this.tokenRepository.save(token);
        return token;
    }

    @Override
    public PersistentResourceToken get(EntityReference resource) {
        return this.bind(this.tokenRepository.getByTypeAndResourceId(resource.getType(), resource.getId()));
    }

    @Override
    public PersistentResourceToken get(String token) {
        return this.bind(this.tokenRepository.getByToken(token));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void remove(EntityReference resource) {
        PersistentResourceToken token = this.get(resource);
        if (token.exists()) {
            this.tokenRepository.delete(token);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void remove(String token) {
        PersistentResourceToken ptoken = this.get(token);
        if (ptoken.exists()) {
            this.tokenRepository.delete(ptoken);
        }
    }

    private PersistentResourceToken bind(PersistentResourceToken token) {
        if (token == null) {
            return PersistentResourceToken.NoneToken;
        }
        return token;
    }
}

