/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.token.synchronizer;

import com.silverpeas.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.silverpeas.token.Token;
import org.silverpeas.token.TokenGenerationParameter;
import org.silverpeas.token.TokenGenerator;
import org.silverpeas.token.persistent.PersistentResourceToken;
import org.silverpeas.token.synchronizer.SynchronizerToken;
import org.silverpeas.util.Charsets;

public class SynchronizerTokenGenerator
implements TokenGenerator {
    public SynchronizerToken generate(final TokenGenerationParameter ... parameters) {
        final ArrayList<String> alterators = new ArrayList<String>(parameters.length);
        String value = this.compute(new Iterator<String>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < parameters.length;
            }

            @Override
            public String next() {
                Object parameter;
                String value = null;
                if ((parameter = parameters[this.i++].value()) instanceof String) {
                    value = (String)parameter;
                    alterators.add(value);
                }
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        return new SynchronizerToken(value, alterators);
    }

    @Override
    public <T extends Token> T renew(T token) {
        if (!(token instanceof SynchronizerToken)) {
            throw new IllegalArgumentException("The token type isn't taken in charge by this generator. Excepted " + PersistentResourceToken.class.getSimpleName() + " but was " + token.getClass().getSimpleName());
        }
        SynchronizerToken synchronizerToken = (SynchronizerToken)token;
        String newValue = this.compute(synchronizerToken.getGenerationParameters().iterator());
        synchronizerToken.setValue(newValue);
        return token;
    }

    private String alter(String base, String value) {
        byte[] v = value.getBytes(Charsets.UTF_8);
        byte[] b = base.getBytes(Charsets.UTF_8);
        int l = v.length;
        byte[] m = b;
        if (b.length < v.length) {
            l = b.length;
            m = v;
        }
        for (int i = 0; i < l; ++i) {
            m[i] = (byte)(b[i] ^ v[i]);
        }
        return new String(m, Charsets.UTF_8);
    }

    private static String random() {
        return UUID.randomUUID().toString();
    }

    private static String encode(String value) {
        return StringUtil.asBase64(value.getBytes(Charsets.UTF_8));
    }

    private String compute(Iterator<String> parameters) {
        String value = SynchronizerTokenGenerator.random();
        while (parameters.hasNext()) {
            String parameter = parameters.next();
            if (parameter == null) continue;
            value = this.alter(value, parameters.next());
        }
        return SynchronizerTokenGenerator.encode(value);
    }
}

