/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.crypto;

import com.silverpeas.util.ArrayUtil;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.text.MessageFormat;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.silverpeas.util.Charsets;
import org.silverpeas.util.crypto.Cipher;
import org.silverpeas.util.crypto.CipherKey;
import org.silverpeas.util.crypto.CryptoException;
import org.silverpeas.util.crypto.CryptographicAlgorithmName;

public abstract class BlockCipherWithPadding
implements Cipher {
    private static final String OPERATION_MODE = "CBC";
    private static final String PADDING_SCHEME = "PKCS5Padding";
    private static final String SILVERPEAS_JCE_PROVIDER = "BC";
    private static final String TRANSFORMATION_PATTERN = "{0}/CBC/PKCS5Padding";

    protected BlockCipherWithPadding() {
    }

    public static byte[] combineEncryptionData(byte[] cipherText, byte[] iv) {
        if (iv != null) {
            return ArrayUtil.addAll((byte[])iv, (byte[])cipherText);
        }
        return cipherText;
    }

    public static byte[][] extractEncryptionData(byte[] encryptedData, BlockCipherWithPadding cipher) throws CryptoException {
        try {
            javax.crypto.Cipher jceCipher = javax.crypto.Cipher.getInstance(cipher.getTransformation(), SILVERPEAS_JCE_PROVIDER);
            int blockSize = jceCipher.getBlockSize();
            byte[][] data = new byte[2][];
            data[1] = ArrayUtil.subarray((byte[])encryptedData, (int)0, (int)blockSize);
            data[0] = ArrayUtil.subarray((byte[])encryptedData, (int)blockSize, (int)encryptedData.length);
            return data;
        }
        catch (Exception ex) {
            throw new CryptoException("The extraction of the ciphertext and of the IV from the specified encrypted data failed!", ex);
        }
    }

    @Override
    public abstract CryptographicAlgorithmName getAlgorithmName();

    @Override
    public byte[] encrypt(String data, CipherKey keyCode) throws CryptoException {
        try {
            this.assertKeyIsBinary(keyCode);
            byte[] keyRaw = keyCode.getRawKey();
            SecretKeySpec keySpec = new SecretKeySpec(keyRaw, this.getAlgorithmName().name());
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(this.getTransformation(), SILVERPEAS_JCE_PROVIDER);
            cipher.init(1, keySpec);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] cipherText = cipher.doFinal(data.getBytes(Charsets.UTF_8));
            return BlockCipherWithPadding.combineEncryptionData(cipherText, iv);
        }
        catch (Exception ex) {
            throw new CryptoException("The encryption failed!", ex);
        }
    }

    @Override
    public String decrypt(byte[] encryptedData, CipherKey keyCode) throws CryptoException {
        try {
            this.assertKeyIsBinary(keyCode);
            byte[] keyRaw = keyCode.getRawKey();
            byte[][] encryptionData = BlockCipherWithPadding.extractEncryptionData(encryptedData, this);
            byte[] cipherText = encryptionData[0];
            byte[] iv = encryptionData[1];
            SecretKeySpec keySpec = new SecretKeySpec(keyRaw, this.getAlgorithmName().name());
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(this.getTransformation(), SILVERPEAS_JCE_PROVIDER);
            cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
            byte[] decryptedData = cipher.doFinal(cipherText);
            return new String(decryptedData, Charsets.UTF_8);
        }
        catch (Exception ex) {
            throw new CryptoException("The decryption failed!", ex);
        }
    }

    @Override
    public CipherKey generateCipherKey() throws CryptoException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(this.getAlgorithmName().name(), SILVERPEAS_JCE_PROVIDER);
            SecretKey key = keyGenerator.generateKey();
            return CipherKey.aKeyFromBinary(key.getEncoded());
        }
        catch (Exception ex) {
            throw new CryptoException("The generation of a cipher key failed!", ex);
        }
    }

    private void assertKeyIsBinary(CipherKey key) throws InvalidKeyException {
        if (!key.isRaw()) {
            throw new InvalidKeyException("Invalid key format for this " + this.getAlgorithmName().name() + " cipher!");
        }
    }

    private String getTransformation() {
        return MessageFormat.format(TRANSFORMATION_PATTERN, this.getAlgorithmName().name());
    }
}

