/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.crypto;

import com.silverpeas.util.StringUtil;
import java.io.File;
import java.text.ParseException;

public class CipherKey {
    private byte[] key;
    private String keyFilePath;

    private CipherKey(byte[] aKey) {
        this.key = (byte[])aKey.clone();
    }

    private CipherKey(String akeyFilePath) {
        this.keyFilePath = akeyFilePath;
    }

    public static CipherKey aKeyFromHexText(String hexKey) throws ParseException {
        return new CipherKey(StringUtil.fromHex(hexKey));
    }

    public static CipherKey aKeyFromBase64Text(String base64Key) {
        return new CipherKey(StringUtil.fromBase64(base64Key));
    }

    public static CipherKey aKeyFromBinary(byte[] binaryKey) {
        return new CipherKey(binaryKey);
    }

    public static CipherKey aKeyFromFilePath(String path) {
        return new CipherKey(path);
    }

    public boolean isInFile() {
        if (StringUtil.isDefined(this.keyFilePath)) {
            File keyFile = new File(this.keyFilePath);
            return keyFile.exists() && keyFile.isFile();
        }
        return false;
    }

    public boolean isRaw() {
        return this.key != null;
    }

    public byte[] getRawKey() {
        return this.key;
    }

    public String getKeyFilePath() {
        return this.keyFilePath;
    }
}

