/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.data;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.cache.service.CacheServiceFactory;

public class LastModifiedDateFileThread
extends Thread {
    private static final Map<File, Long> requestMap = new LinkedHashMap<File, Long>();
    private static LastModifiedDateFileThread lastModifiedDateFileThread = null;

    private static void startIfNotAlreadyDone() {
        if (!LastModifiedDateFileThread.isRunning()) {
            lastModifiedDateFileThread = new LastModifiedDateFileThread();
            lastModifiedDateFileThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFile(File file) {
        Map<File, Long> map = requestMap;
        synchronized (map) {
            requestMap.put(file, System.currentTimeMillis());
            LastModifiedDateFileThread.startIfNotAlreadyDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning() {
        Map<File, Long> map = requestMap;
        synchronized (map) {
            return lastModifiedDateFileThread != null;
        }
    }

    private LastModifiedDateFileThread() {
    }

    @Override
    public void run() {
        Pair<File, Long> pair = this.nextRequest();
        while (pair != null) {
            CacheServiceFactory.clearAllThreadCaches();
            try {
                File currentFile = (File)pair.getKey();
                Long lastModifiedDate = (Long)pair.getValue();
                if (currentFile.isFile()) {
                    currentFile.setLastModified(lastModifiedDate);
                } else if (currentFile.isDirectory()) {
                    for (File file : FileUtils.listFilesAndDirs((File)currentFile, (IOFileFilter)FileFilterUtils.trueFileFilter(), (IOFileFilter)FileFilterUtils.trueFileFilter())) {
                        file.setLastModified(lastModifiedDate);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            pair = this.nextRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<File, Long> nextRequest() {
        Map<File, Long> map = requestMap;
        synchronized (map) {
            Pair nextRequest;
            if (!requestMap.isEmpty()) {
                File file = requestMap.keySet().iterator().next();
                Long newLastModifiedTime = requestMap.remove(file);
                nextRequest = Pair.of((Object)file, (Object)newLastModifiedTime);
            } else {
                nextRequest = null;
                lastModifiedDateFileThread = null;
            }
            return nextRequest;
        }
    }
}

