/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.wysiwyg.control.directive;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.silverpeas.util.StringDataExtractor;
import org.silverpeas.wysiwyg.control.WysiwygContentTransformerDirective;

public class ImageUrlAccordingToHtmlSizeDirective
implements WysiwygContentTransformerDirective {
    private static final String WIDTH_ATTR = "width";
    private static final String HEIGHT_ATTR = "height";
    private static final String STYLE_ATTR = "style";
    private static List<StringDataExtractor.RegexpPatternDirective> WIDTH_NUMERIC_VALUE = Arrays.asList(StringDataExtractor.RegexpPatternDirective.regexp(Pattern.compile("(?i)widthAttr[ ]*([0-9]+)"), 1), StringDataExtractor.RegexpPatternDirective.regexp(Pattern.compile("(?i)[ ;]width[ ]*:[ ]*([0-9]+)"), 1));
    private static List<StringDataExtractor.RegexpPatternDirective> HEIGHT_NUMERIC_VALUE = Arrays.asList(StringDataExtractor.RegexpPatternDirective.regexp(Pattern.compile("(?i)heightAttr[ ]*([0-9]+)"), 1), StringDataExtractor.RegexpPatternDirective.regexp(Pattern.compile("(?i)[ ;]height[ ]*:[ ]*([0-9]+)"), 1));

    @Override
    public String execute(String wysiwygContent) {
        String wysiwygToTransform = wysiwygContent != null ? wysiwygContent : "";
        Source source = new Source((CharSequence)wysiwygToTransform);
        List imgElements = source.getAllElements("img");
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (Element currentImg : imgElements) {
            String imgTagContent = currentImg.toString();
            String src = currentImg.getAttributeValue("src");
            if (!src.contains("/attachmentId/") || replacements.containsKey(imgTagContent)) continue;
            String newSrc = src.replaceFirst("(?i)/size/[0-9 x]+", "");
            String width = this.getWidth(currentImg);
            String height = this.getHeight(currentImg);
            String sizeUrlPart = width + "x" + height;
            if (sizeUrlPart.length() > 1) {
                sizeUrlPart = "/size/" + sizeUrlPart;
                newSrc = newSrc.replaceFirst("/name/", sizeUrlPart + "/name/");
            }
            if (src.equals(newSrc)) continue;
            replacements.put(imgTagContent, imgTagContent.replace(src, newSrc));
        }
        String transformedWysiwygContent = wysiwygToTransform;
        for (Map.Entry replacement : replacements.entrySet()) {
            transformedWysiwygContent = transformedWysiwygContent.replace((CharSequence)replacement.getKey(), (CharSequence)replacement.getValue());
        }
        return transformedWysiwygContent;
    }

    private String getWidth(Element imgElement) {
        return this.getSizeOf(WIDTH_NUMERIC_VALUE, imgElement, WIDTH_ATTR);
    }

    private String getHeight(Element imgElement) {
        return this.getSizeOf(HEIGHT_NUMERIC_VALUE, imgElement, HEIGHT_ATTR);
    }

    private String getSizeOf(List<StringDataExtractor.RegexpPatternDirective> directives, Element imgElement, String attrName) {
        String stringToParse = ";" + imgElement.getAttributeValue(STYLE_ATTR) + "@" + attrName + "Attr" + imgElement.getAttributeValue(attrName);
        List<String> sizeData = StringDataExtractor.from(stringToParse.replaceAll("[\n\r]*", "")).withDirectives(directives).extract();
        return sizeData.isEmpty() ? "" : sizeData.get(0);
    }
}

