/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.admin.components;

import com.silverpeas.admin.components.GroupOfParameters;
import com.silverpeas.admin.components.GroupOfParametersSorter;
import com.silverpeas.admin.components.MultilangHashMapAdapter;
import com.silverpeas.admin.components.Parameter;
import com.silverpeas.admin.components.ParameterList;
import com.silverpeas.admin.components.ParameterSorter;
import com.silverpeas.admin.components.Profile;
import com.silverpeas.ui.DisplayI18NHelper;
import com.silverpeas.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="WAComponentType", propOrder={"name", "label", "description", "suite", "visible", "visibleInPersonalSpace", "portlet", "router", "instanceClassName", "profiles", "groupsOfParameters", "parameters"})
public class WAComponent {
    @XmlTransient
    private ParameterSorter sorter = new ParameterSorter();
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected HashMap<String, String> label;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected HashMap<String, String> description;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected HashMap<String, String> suite;
    protected boolean visible;
    protected boolean visibleInPersonalSpace = false;
    protected boolean portlet;
    protected String router;
    @XmlElement(required=true)
    protected String instanceClassName;
    @XmlElementWrapper(name="profiles")
    @XmlElement(name="profile", required=true)
    protected List<Profile> profiles;
    @XmlElementWrapper(name="groupsOfParameters")
    @XmlElement(name="groupOfParameters")
    protected List<GroupOfParameters> groupsOfParameters;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    protected List<Parameter> parameters;
    @XmlTransient
    protected Map<String, Parameter> indexedParametersByName = new HashMap<String, Parameter>();

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public HashMap<String, String> getLabel() {
        if (this.label == null) {
            this.label = new HashMap();
        }
        return this.label;
    }

    public String getLabel(String lang) {
        if (this.getLabel().containsKey(lang)) {
            return this.getLabel().get(lang);
        }
        return this.getLabel().get(DisplayI18NHelper.getDefaultLanguage());
    }

    public void setLabel(HashMap<String, String> value) {
        this.label = value;
    }

    public HashMap<String, String> getDescription() {
        if (this.description == null) {
            this.description = new HashMap();
        }
        return this.description;
    }

    public String getDescription(String lang) {
        if (this.getDescription().containsKey(lang)) {
            return this.getDescription().get(lang);
        }
        return this.getDescription().get(DisplayI18NHelper.getDefaultLanguage());
    }

    public void setDescription(HashMap<String, String> value) {
        this.description = value;
    }

    public HashMap<String, String> getSuite() {
        if (this.suite == null) {
            this.suite = new HashMap();
        }
        return this.suite;
    }

    public String getSuite(String lang) {
        if (this.getSuite().containsKey(lang)) {
            return this.getSuite().get(lang);
        }
        return this.getSuite().get(DisplayI18NHelper.getDefaultLanguage());
    }

    public void setSuite(HashMap<String, String> value) {
        this.suite = value;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public boolean isVisibleInPersonalSpace() {
        return this.visibleInPersonalSpace;
    }

    public void setVisibleInPersonalSpace(boolean value) {
        this.visibleInPersonalSpace = value;
    }

    public boolean isPortlet() {
        return this.portlet;
    }

    public void setPortlet(boolean value) {
        this.portlet = value;
    }

    public String getRouter() {
        return this.router;
    }

    public void setRouter(String value) {
        this.router = value;
    }

    public String getInstanceClassName() {
        return this.instanceClassName;
    }

    public void setInstanceClassName(String value) {
        this.instanceClassName = value;
    }

    public List<Profile> getProfiles() {
        if (this.profiles == null) {
            this.profiles = new ArrayList<Profile>();
        }
        return this.profiles;
    }

    public Profile getProfile(String name) {
        for (Profile profile : this.getProfiles()) {
            if (!profile.getName().equals(name)) continue;
            return profile;
        }
        return null;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    private Map<String, Parameter> getIndexedParametersByName() {
        List<Parameter> definedParameters = this.getParameters();
        if (CollectionUtil.isNotEmpty(definedParameters) && definedParameters.size() != this.indexedParametersByName.size()) {
            for (Parameter parameter : definedParameters) {
                this.indexedParametersByName.put(parameter.getName(), parameter);
            }
        }
        List<GroupOfParameters> groupsOfParameters = this.getGroupsOfParameters();
        for (GroupOfParameters group : groupsOfParameters) {
            for (Parameter parameter : group.getParameters()) {
                this.indexedParametersByName.put(parameter.getName(), parameter);
            }
        }
        return this.indexedParametersByName;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        this.indexedParametersByName.clear();
    }

    public boolean hasParameterDefined(String parameterName) {
        return this.getIndexedParametersByName().get(parameterName) != null;
    }

    public List<Parameter> getSortedParameters() {
        Collections.sort(this.getParameters(), this.sorter);
        return this.parameters;
    }

    public ParameterList getAllParameters() {
        ParameterList result = new ParameterList();
        for (Parameter param : this.getParameters()) {
            result.add(param);
        }
        for (GroupOfParameters group : this.getGroupsOfParameters()) {
            result.addAll(group.getParameters());
        }
        return result;
    }

    public List<GroupOfParameters> getGroupsOfParameters() {
        if (this.groupsOfParameters == null) {
            this.groupsOfParameters = new ArrayList<GroupOfParameters>();
        }
        return this.groupsOfParameters;
    }

    public List<GroupOfParameters> getSortedGroupsOfParameters() {
        Collections.sort(this.getGroupsOfParameters(), new GroupOfParametersSorter());
        return this.groupsOfParameters;
    }
}

