/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.admin.notification;

import com.silverpeas.admin.notification.AdminNotificationService;
import com.silverpeas.admin.notification.ComponentJsonPatch;
import com.silverpeas.notification.NotificationPublisher;
import com.silverpeas.notification.NotificationSource;
import com.silverpeas.notification.NotificationTopic;
import com.silverpeas.notification.RegisteredTopics;
import com.silverpeas.notification.SilverpeasNotification;
import com.silverpeas.notification.SilverpeasNotificationCause;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="adminNotificationService")
public class DefaultAdminNotificationService
implements AdminNotificationService {
    @Inject
    private NotificationPublisher publisher;

    @Override
    public void notifyOnDeletionOf(String spaceId, String userId) {
        SilverpeasNotification notification = new SilverpeasNotification(new NotificationSource().withUserId(userId), SilverpeasNotificationCause.DELETION, (Serializable)((Object)spaceId));
        this.publisher.publish(notification, NotificationTopic.onTopic(RegisteredTopics.ADMIN_SPACE_TOPIC));
    }

    @Override
    public void notifyOfComponentConfigurationChange(String componentId, String userId, ComponentJsonPatch changes) {
        SilverpeasNotification notification = new SilverpeasNotification(new NotificationSource().withComponentInstanceId(componentId), SilverpeasNotificationCause.UPDATE, changes);
        this.publisher.publish(notification, NotificationTopic.onTopic(RegisteredTopics.ADMIN_COMPONENT_TOPIC));
    }
}

