/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.admin.spaces;

import com.silverpeas.admin.components.Parameter;
import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.admin.spaces.SpaceComponent;
import com.silverpeas.admin.spaces.SpaceComponentParameter;
import com.silverpeas.admin.spaces.SpaceTemplate;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;

public class SpaceInstanciator {
    protected static ResourceLocator configuration = new ResourceLocator("com.stratelia.webactiv.beans.admin.admin", "");
    private Map<String, SpaceTemplate> spaceTemplates = new HashMap<String, SpaceTemplate>();
    private final Map<String, WAComponent> allComponentsModels;

    SpaceInstanciator(Map<String, WAComponent> allComponentsModels, String xmlPackage) {
        this.allComponentsModels = allComponentsModels;
        File file = new File(xmlPackage);
        String[] list = file.list();
        if (list != null) {
            try {
                JAXBContext context = JAXBContext.newInstance((String)"com.silverpeas.admin.spaces");
                XMLInputFactory factory = XMLInputFactory.newFactory();
                Unmarshaller unmarshaller = context.createUnmarshaller();
                for (String fileName : list) {
                    if (!fileName.toLowerCase().endsWith(".xml")) continue;
                    String spaceName = fileName.substring(0, fileName.length() - 4);
                    String fullPath = xmlPackage + File.separator + fileName;
                    SilverTrace.info("admin", "SpaceInstanciateur.SpaceInstanciateur", "admin.MSG_INFO_BUILD_WA_COMPONENT_LIST", "space name: '" + spaceName + "', full path: '" + fullPath + "'");
                    SpaceTemplate template = (SpaceTemplate)unmarshaller.unmarshal(factory.createXMLStreamReader(new FileInputStream(fullPath)), SpaceTemplate.class).getValue();
                    this.spaceTemplates.put(spaceName, template);
                }
            }
            catch (JAXBException ex) {
                SilverTrace.fatal("admin", "SpaceInstanciator", "admin.MSG_INFO_BUILD_WA_COMPONENT_LIST", ex);
            }
            catch (XMLStreamException ex) {
                SilverTrace.fatal("admin", "SpaceInstanciator", "admin.MSG_INFO_BUILD_WA_COMPONENT_LIST", ex);
            }
            catch (FileNotFoundException ex) {
                SilverTrace.fatal("admin", "SpaceInstanciator", "admin.MSG_INFO_BUILD_WA_COMPONENT_LIST", ex);
            }
        }
    }

    public SpaceInstanciator(Map<String, WAComponent> allComponentsModels) {
        this(allComponentsModels, configuration.getString("xmlSpaceTemplate").trim());
    }

    public Map<String, SpaceTemplate> getAllSpaceTemplates() {
        return Collections.unmodifiableMap(this.spaceTemplates);
    }

    public SpaceInst getSpaceToInstanciate(String templateName) {
        SpaceTemplate st = this.spaceTemplates.get(templateName);
        if (st == null) {
            SilverTrace.info("admin", "SpaceInstanciateur.getSpaceToInstanciate", "admin.MSG_INFO_BUILD_WA_COMPONENT_LIST", "template Name : '" + templateName + "' NOT FOUND !!!!!!!!!");
            return null;
        }
        SilverTrace.info("admin", "SpaceInstanciateur.getSpaceToInstanciate", "admin.MSG_INFO_BUILD_WA_COMPONENT_LIST", "template Name : '" + templateName);
        return this.makeSpaceInst(st);
    }

    public SpaceInst makeSpaceInst(SpaceTemplate st) {
        SpaceInst space = new SpaceInst();
        space.setName(st.getDefaultName());
        space.setDescription(st.getDescription());
        for (SpaceComponent component : st.getComponents()) {
            WAComponent wacomponent = this.allComponentsModels.get(component.getType());
            if (wacomponent == null) continue;
            ComponentInst ci = new ComponentInst();
            ci.setOrderNum(space.getNumComponentInst());
            ci.setName(component.getType());
            ci.setLabel(component.getLabel());
            ci.setDescription(component.getDescription());
            ci.setParameters(wacomponent.getParameters());
            for (SpaceComponentParameter param : component.getParameters()) {
                Parameter parameter = ci.getParameter(param.getName());
                if (parameter == null) continue;
                parameter.setValue(param.getValue());
            }
            space.addComponentInst(ci);
        }
        SilverTrace.info("admin", "SpaceTemplate.makeSpaceInst", "root.MSG_GEN_PARAM_VALUE", "defaultSpaceName : " + space.getName() + " NbCompo: " + space.getNumComponentInst());
        return space;
    }
}

