/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.annotation.constraint;

import com.silverpeas.annotation.constraint.DateRange;
import com.silverpeas.calendar.Datable;
import com.silverpeas.calendar.Date;
import com.silverpeas.calendar.DateTime;
import java.lang.reflect.Field;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class DateRangeValidator
implements ConstraintValidator<DateRange, Object> {
    private String startDateFieldName;
    private String endDateFieldName;

    public void initialize(DateRange constraintAnnotation) {
        this.startDateFieldName = constraintAnnotation.startDate();
        this.endDateFieldName = constraintAnnotation.endDate();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        boolean isValid = false;
        try {
            Date end;
            Date start;
            Field startDateField = object.getClass().getDeclaredField(this.startDateFieldName);
            Field endDateField = object.getClass().getDeclaredField(this.endDateFieldName);
            startDateField.setAccessible(true);
            endDateField.setAccessible(true);
            Datable startDate = (Datable)startDateField.get(object);
            Datable endDate = (Datable)endDateField.get(object);
            isValid = startDate instanceof Date || endDate instanceof Date ? (start = new Date(startDate.asDate())).isBefore(end = new Date(endDate.asDate())) || start.isEqualTo(end) : (start = (DateTime)startDate).isBefore(end = (DateTime)endDate) || start.isEqualTo(end);
        }
        catch (Exception ex) {
            isValid = false;
        }
        return isValid;
    }
}

