/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.Field;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractTextFieldDisplayer<T extends Field>
extends AbstractFieldDisplayer<TextField> {
    private static final String[] MANAGED_TYPES = new String[]{"text"};

    public String[] getManagedTypes() {
        return MANAGED_TYPES;
    }

    protected void addMandatoryScript(StringBuilder script, FieldTemplate template, PagesContext pageContext) {
        if (template.isMandatory() && pageContext.useMandatory()) {
            String language = pageContext.getLanguage();
            String label = template.getLabel(language);
            script.append("   if (isWhitespace(stripInitialWhitespace(field.value))) {\n");
            script.append("     errorMsg+=\"  - '").append(label).append("' ").append(Util.getString("GML.MustBeFilled", language)).append("\\n\";\n");
            script.append("     errorNb++;\n");
            script.append("   }\n");
        }
    }

    protected void addSpecificScript(PrintWriter out, FieldTemplate template, PagesContext pageContext) {
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
        String language = pagesContext.getLanguage();
        String label = template.getLabel(language);
        if (!template.getTypeName().equals("text")) {
            SilverTrace.info("form", "TextFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        StringBuilder script = new StringBuilder(10000);
        this.addMandatoryScript(script, template, pagesContext);
        this.addSpecificScript(out, template, pagesContext);
        Map<String, String> parameters = template.getParameters(pagesContext.getLanguage());
        String contentType = parameters.get("contentType");
        if (contentType != null) {
            if (contentType.equals("int")) {
                script.append("   if (field.value != \"\" && !(/^-?\\d+$/.test(field.value))) {\n");
                script.append("     errorMsg+=\"  - '").append(label).append("' ").append(Util.getString("GML.MustContainsNumber", language)).append("\\n\";\n");
                script.append("     errorNb++;\n");
                script.append("   }\n");
            } else if (contentType.equals("float")) {
                script.append("   field.value = field.value.replace(\",\", \".\")\n");
                script.append("   if (field.value != \"\" && !(/^([+-]?(((\\d+(\\.)?)|(\\d*\\.\\d+))");
                script.append("([eE][+-]?\\d+)?))$/.test(field.value))) {\n");
                script.append("     errorMsg+=\"  - '").append(label).append("' ");
                script.append(Util.getString("GML.MustContainsFloat", language)).append("\\n\";\n");
                script.append("     errorNb++;\n");
                script.append("   }\n");
            }
        }
        String nbMaxCar = parameters.containsKey("maxLength") ? parameters.get("maxLength") : Util.getSetting("nbMaxCar");
        script.append("   if (! isValidText(field, ").append(nbMaxCar).append(")) {\n");
        script.append("     errorMsg+=\"  - '").append(label).append("' ").append(Util.getString("ContainsTooLargeText", language)).append(nbMaxCar).append(" ").append(Util.getString("Characters", language)).append("\\n\";\n");
        script.append("     errorNb++;\n");
        script.append("   }\n");
        out.print(script.toString());
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("AbstractTextFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "text");
        }
        if (!field.acceptValue(newValue, PagesContext2.getLanguage())) {
            throw new FormException("AbstractTextFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "text");
        }
        field.setValue(newValue, PagesContext2.getLanguage());
        return new ArrayList<String>();
    }
}

