/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.DateField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.DateUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.span;

public class DateFieldDisplayer
extends AbstractFieldDisplayer<DateField> {
    public String[] getManagedTypes() {
        return new String[]{"date"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
        String language = pagesContext.getLanguage();
        if (template.isMandatory() && pagesContext.useMandatory()) {
            out.println("\t\tif (isWhitespace(stripInitialWhitespace(field.value))) {");
            out.println("\t\t\terrorMsg+=\"  - '" + EncodeHelper.javaStringToJsString(template.getLabel(language)) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n\";");
            out.println("\t\t\terrorNb++;");
            out.println("\t\t}");
        }
        out.println("\t\tif (! isWhitespace(stripInitialWhitespace(field.value))) {");
        out.println("\t\t\tif (! isCorrectDate(extractYear(field.value, '" + language + "'), extractMonth(field.value, '" + language + "'), extractDay(field.value, '" + language + "'))) {");
        out.println("\t\t\t\terrorMsg+=\"  - '" + EncodeHelper.javaStringToJsString(template.getLabel(language)) + "' " + Util.getString("GML.MustContainsCorrectDate", language) + "\\n\";");
        out.println("\t\t\t\terrorNb++;");
        out.println("\t\t}}");
        out.println("\t\tif (! isValidText(field, " + Util.getSetting("nbMaxCar") + ")) {");
        out.println("\t\t\terrorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("ContainsTooLargeText", language) + Util.getSetting("nbMaxCar") + " " + Util.getString("Characters", language) + "\\n\";");
        out.println("\t\t\terrorNb++;");
        out.println("\t\t}");
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, DateField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        String value;
        String language = pagesContext.getLanguage();
        Map<String, String> parameters = template.getParameters(language);
        String fieldName = template.getFieldName();
        String cssClass = null;
        if (parameters.containsKey("class") && StringUtil.isDefined(cssClass = parameters.get("class"))) {
            cssClass = "class=\"" + cssClass + "\"";
        }
        String defaultParam = parameters.containsKey("default") ? parameters.get("default") : "";
        String defaultValue = "";
        if ("now".equalsIgnoreCase(defaultParam) && !pagesContext.isIgnoreDefaultValues()) {
            defaultValue = DateUtil.dateToString(new Date(), pagesContext.getLanguage());
        }
        String string = value = !field.isNull() ? field.getValue(language) : defaultValue;
        if (pagesContext.isBlankFieldsUse()) {
            value = "";
        }
        input inputField = new input();
        inputField.setID(fieldName);
        inputField.setName(fieldName);
        inputField.setValue(EncodeHelper.javaStringToHtmlString(value));
        inputField.setType(template.isHidden() ? "hidden" : "text");
        inputField.setMaxlength(parameters.containsKey("maxLength") ? parameters.get("maxLength") : "10");
        inputField.setSize(parameters.containsKey("size") ? parameters.get("size") : "13");
        if (parameters.containsKey("border")) {
            inputField.setBorder(Integer.parseInt(parameters.get("border")));
        }
        if (template.isDisabled()) {
            inputField.setDisabled(true);
        } else if (template.isReadOnly()) {
            inputField.setReadOnly(true);
        }
        if (!(template.isHidden() || template.isDisabled() || template.isReadOnly())) {
            inputField.setClass("dateToPick");
            ElementContainer container = new ElementContainer();
            container.addElement((Element)inputField);
            span spanCSS = new span();
            if (StringUtil.isDefined(cssClass)) {
                spanCSS.setClass(cssClass);
            } else {
                spanCSS.setClass("txtnote");
            }
            spanCSS.addElement("(" + Util.getString("GML.dateFormatExemple", language) + ")");
            container.addElement((Element)spanCSS);
            if (template.isMandatory() && pagesContext.useMandatory()) {
                container.addElement("&nbsp;");
                img image = new img();
                image.setSrc(Util.getIcon("mandatoryField"));
                image.setWidth(5);
                image.setHeight(5);
                image.setBorder(0);
                image.setAlt("");
                container.addElement((Element)image);
            }
            out.println(container.toString());
        } else {
            out.println(inputField.toString());
        }
    }

    @Override
    public List<String> update(String newValue, DateField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!field.acceptValue(newValue, pagesContext.getLanguage())) {
            throw new FormException("DateFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "date");
        }
        field.setValue(newValue, pagesContext.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

