/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractTextFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.PrintWriter;
import java.util.Map;

public class TextAreaFieldDisplayer
extends AbstractTextFieldDisplayer<TextField> {
    public static final String PARAM_ROWS = "rows";
    public static final String PARAM_COLS = "cols";

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        String value = "";
        String rows = "8";
        String cols = "100";
        String html = "";
        String cssClass = null;
        String fieldName = Util.getFieldOccurrenceName(template.getFieldName(), field.getOccurrence());
        Map<String, String> parameters = template.getParameters(PagesContext2.getLanguage());
        if (!field.getTypeName().equals("text")) {
            SilverTrace.info("form", "TextAreaFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        if (!field.isNull()) {
            value = field.getValue(PagesContext2.getLanguage());
        }
        if (parameters.containsKey("class") && StringUtil.isDefined(cssClass = parameters.get("class"))) {
            cssClass = "class=\"" + cssClass + "\"";
        }
        if (StringUtil.isDefined(cssClass)) {
            html = html + "<span " + cssClass + ">";
        }
        html = html + "<textarea id=\"" + fieldName + "\" name=\"" + fieldName + "\"";
        if (parameters.containsKey(PARAM_ROWS)) {
            rows = parameters.get(PARAM_ROWS);
        }
        html = html + " rows=\"" + rows + "\"";
        if (parameters.containsKey(PARAM_COLS)) {
            cols = parameters.get(PARAM_COLS);
        }
        html = html + " cols=\"" + cols + "\"";
        if (template.isDisabled()) {
            html = html + " disabled=\"disabled\"";
        } else if (template.isReadOnly()) {
            html = html + " readonly=\"readonly\"";
        }
        html = html + " >" + EncodeHelper.javaStringToHtmlString(value) + "</textarea>";
        if (StringUtil.isDefined(cssClass)) {
            html = html + "</span>";
        }
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && PagesContext2.useMandatory()) {
            html = html + Util.getMandatorySnippet();
        }
        out.println(html);
    }
}

