/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.stratelia.silverpeas.peasCore.URLManager;
import java.text.MessageFormat;
import java.util.Random;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.script;

public class VideoPlayer {
    private static final String webContext = URLManager.getApplicationURL();
    private static final String playerUrl = webContext + "/util/flash/flowplayer/flowplayer-3.2.7.swf";
    private static final Random randomGenerator = new Random();
    private static final String flowPlayerJS = webContext + "/util/javaScript/flowplayer/flowplayer-3.2.6.min.js";
    private static final String flowPlayerCSS = webContext + "/util/styleSheets/flowplayer.css";
    private static final String playerStyle = "<link type='text/css' href='" + flowPlayerCSS + "' rel='stylesheet' />";
    private static final String templateScript = "flowplayer(''{0}'', ''{1}'', '{'wmode: ''opaque'', clip: '{' autoBuffering: {2}, autoPlay: {3} '}' '}')";
    private String videoURL = "";
    private boolean autoplay = false;
    private String width = "425px";
    private String height = "300px";

    public VideoPlayer(String videoURL, boolean autoplay) {
        this.videoURL = videoURL;
        this.autoplay = autoplay;
    }

    public VideoPlayer() {
    }

    public boolean isAutoplay() {
        return this.autoplay;
    }

    public void setAutoplay(boolean autoplay) {
        this.autoplay = autoplay;
    }

    public String getVideoURL() {
        return this.videoURL;
    }

    public void setVideoURL(String videoURL) {
        this.videoURL = videoURL == null ? "" : videoURL;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    private String generateId() {
        return "player" + randomGenerator.nextInt();
    }

    public void init(ConcreteElement element) {
        script cssLoading = new script("$(document.head).append(\"" + playerStyle + "\")").setType("text/javascript");
        script jsInclusion = new script().setType("text/javascript").setSrc(flowPlayerJS);
        if (element instanceof ElementContainer) {
            ElementContainer container = (ElementContainer)element;
            container.addElement((Element)cssLoading).addElement((Element)jsInclusion);
        } else {
            element.addElementToRegistry((Element)cssLoading).addElementToRegistry((Element)jsInclusion);
        }
    }

    public void renderIn(ConcreteElement element) {
        String videoId = this.generateId();
        if (!this.getVideoURL().isEmpty()) {
            a video = new a().setHref(this.getVideoURL());
            video.setStyle("display:block;width:" + this.getWidth() + ";height:" + this.getHeight() + ";");
            video.setID(videoId);
            if (element instanceof ElementContainer) {
                ((ElementContainer)element).addElement((Element)video);
            } else {
                element.addElementToRegistry((Element)video);
            }
        }
        script player = new script(MessageFormat.format(templateScript, videoId, playerUrl, !this.isAutoplay(), this.isAutoplay())).setType("text/javascript");
        if (element instanceof ElementContainer) {
            ((ElementContainer)element).addElement((Element)player);
        } else {
            element.addElementToRegistry((Element)player);
        }
    }
}

