/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jcrutil;

import com.silverpeas.jcrutil.converter.ConverterUtil;
import com.silverpeas.jcrutil.security.impl.SilverpeasSystemCredentials;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.FileUtil;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.exception.UtilException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BasicDaoFactory
implements ApplicationContextAware {
    public static final String JRC_REPOSITORY = "repository";
    private ApplicationContext context;
    private static final BasicDaoFactory instance = new BasicDaoFactory();

    private BasicDaoFactory() {
    }

    protected ApplicationContext getApplicationContext() {
        return this.context;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public static BasicDaoFactory getInstance() {
        return instance;
    }

    public static Object getBean(String name) {
        return BasicDaoFactory.getInstance().getApplicationContext().getBean(name);
    }

    public static Session getSystemSession() throws LoginException, RepositoryException {
        return ((Repository)BasicDaoFactory.getInstance().getApplicationContext().getBean(JRC_REPOSITORY)).login((Credentials)new SilverpeasSystemCredentials());
    }

    public static Session getAuthentifiedSession(String login, String password) throws LoginException, RepositoryException {
        return ((Repository)BasicDaoFactory.getInstance().getApplicationContext().getBean(JRC_REPOSITORY)).login((Credentials)new SimpleCredentials(login, password.toCharArray()));
    }

    public static void logout(Session session) {
        if (session != null) {
            session.logout();
        }
    }

    public static String getComponentId(Node node) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return ConverterUtil.convertFromJcrPath(node.getAncestor(1).getName());
    }

    public static void addStringProperty(Node node, String propertyName, String value) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            try {
                node.getProperty(propertyName).remove();
            }
            catch (PathNotFoundException pathNotFoundException) {}
        } else {
            node.setProperty(propertyName, value);
        }
    }

    public static void addDateProperty(Node node, String propertyName, Date value) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            try {
                node.getProperty(propertyName).remove();
            }
            catch (PathNotFoundException pnfex) {}
        } else {
            Calendar calend = Calendar.getInstance();
            calend.setTime(value);
            Value propertyValue = node.getSession().getValueFactory().createValue(calend);
            node.setProperty(propertyName, propertyValue);
        }
    }

    public static void addCalendarProperty(Node node, String propertyName, Calendar value) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            try {
                node.getProperty(propertyName).remove();
            }
            catch (PathNotFoundException pnfex) {}
        } else {
            Value propertyValue = node.getSession().getValueFactory().createValue(value);
            node.setProperty(propertyName, propertyValue);
        }
    }

    public static String getStringProperty(Node node, String propertyName) throws ValueFormatException, RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return null;
    }

    public static Calendar getCalendarProperty(Node node, String propertyName) throws ValueFormatException, RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getDate();
        }
        return null;
    }

    public static Date getDateProperty(Node node, String propertyName) throws ValueFormatException, RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getDate().getTime();
        }
        return null;
    }

    public static int getIntProperty(Node node, String propertyName) throws ValueFormatException, RepositoryException {
        if (node.hasProperty(propertyName)) {
            return Long.valueOf(node.getProperty(propertyName).getLong()).intValue();
        }
        return 0;
    }

    public static long getLongProperty(Node node, String propertyName) throws ValueFormatException, RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getLong();
        }
        return 0L;
    }

    public static Value[] removeReference(Value[] values, String uuid) throws ValueFormatException, IllegalStateException, RepositoryException {
        ArrayList<Value> references = new ArrayList<Value>(Arrays.asList(values));
        Iterator iter = references.iterator();
        while (iter.hasNext()) {
            Value value = (Value)iter.next();
            if (!uuid.equals(value.getString())) continue;
            iter.remove();
            return references.toArray(new Value[values.length - 1]);
        }
        return values;
    }

    public static String computeUniqueName(String prefix, String tableName) throws UtilException {
        return prefix + DBUtil.getNextId(tableName, null);
    }

    public static void setContent(Node fileNode, InputStream content, String mimeType) throws RepositoryException {
        Node contentNode = fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content") ? fileNode.getNode("{http://www.jcp.org/jcr/1.0}content") : fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "nt:resource");
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}data", content);
        String fileMimeType = mimeType;
        if (fileMimeType == null) {
            fileMimeType = FileUtil.getMimeType(fileNode.getProperty("slv:name").getString());
        }
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", fileMimeType);
        Calendar lastModified = Calendar.getInstance();
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", lastModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContent(Node fileNode, File file, String mimeType) throws RepositoryException, IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            BasicDaoFactory.setContent(fileNode, in, mimeType);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContent(Node fileNode, byte[] content, String mimeType) throws RepositoryException, IOException {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(content);
            BasicDaoFactory.setContent(fileNode, in, mimeType);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(Node fileNode) throws RepositoryException, IOException {
        InputStream in;
        ByteArrayOutputStream out;
        block4: {
            out = new ByteArrayOutputStream();
            in = null;
            if (!fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content")) break block4;
            Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
            in = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
            return byArray;
        }
        try {
            byte[] byArray = ArrayUtil.EMPTY_BYTE_ARRAY;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getContent(Node fileNode, OutputStream out) throws RepositoryException, IOException {
        InputStream in = null;
        try {
            if (fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
                Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
                in = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static long getSize(Node contentNode) throws ValueFormatException, PathNotFoundException, RepositoryException {
        if (contentNode.hasProperty("{http://www.jcp.org/jcr/1.0}data")) {
            return contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getLength();
        }
        return 0L;
    }
}

