/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jcrutil.security.impl;

import com.silverpeas.jcrutil.security.impl.DigestCredentials;
import com.silverpeas.util.StringUtil;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SilverpeasDigestCredentialsProvider
implements CredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(SilverpeasDigestCredentialsProvider.class);

    public Credentials getCredentials(HttpServletRequest request) throws LoginException, ServletException {
        String authorization = request.getHeader("Authorization");
        if (!StringUtil.isDefined(authorization)) {
            throw new LoginException();
        }
        if (log.isDebugEnabled()) {
            log.debug("authorization: " + authorization);
        }
        return this.createDigestCredentials(request, authorization);
    }

    protected DigestCredentials createDigestCredentials(HttpServletRequest request, String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        String[] tokens = authorization.split(",(?=(?:[^\"]*\"[^\"]*\")+$)");
        String userName = null;
        String realmName = null;
        String nOnce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;
        String method = request.getMethod();
        for (String currentToken : tokens) {
            if (currentToken.length() == 0) continue;
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if ("username".equals(currentTokenName)) {
                userName = SilverpeasDigestCredentialsProvider.removeQuotes(currentTokenValue);
            }
            if ("realm".equals(currentTokenName)) {
                realmName = SilverpeasDigestCredentialsProvider.removeQuotes(currentTokenValue, true);
            }
            if ("nonce".equals(currentTokenName)) {
                nOnce = SilverpeasDigestCredentialsProvider.removeQuotes(currentTokenValue);
            }
            if ("nc".equals(currentTokenName)) {
                nc = SilverpeasDigestCredentialsProvider.removeQuotes(currentTokenValue);
            }
            if ("cnonce".equals(currentTokenName)) {
                cnonce = SilverpeasDigestCredentialsProvider.removeQuotes(currentTokenValue);
            }
            if ("qop".equals(currentTokenName)) {
                qop = SilverpeasDigestCredentialsProvider.removeQuotes(currentTokenValue);
            }
            if ("uri".equals(currentTokenName)) {
                uri = SilverpeasDigestCredentialsProvider.removeQuotes(currentTokenValue);
            }
            if (!"response".equals(currentTokenName)) continue;
            response = SilverpeasDigestCredentialsProvider.removeQuotes(currentTokenValue);
        }
        if (userName == null || realmName == null || nOnce == null || uri == null || response == null) {
            return null;
        }
        String a2 = method + ":" + uri;
        String md5a2 = Text.md5((String)a2);
        DigestCredentials dc = new DigestCredentials();
        dc.setUsername(userName);
        dc.setClientDigest(response);
        dc.setNonce(nOnce);
        dc.setNc(nc);
        dc.setCnonce(cnonce);
        dc.setQop(qop);
        dc.setRealm(realmName);
        dc.setMd5a2(md5a2);
        return dc;
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return "";
    }

    protected static String removeQuotes(String quotedString) {
        return SilverpeasDigestCredentialsProvider.removeQuotes(quotedString, false);
    }
}

