/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.builder;

import com.silverpeas.notification.builder.UserNotification;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.NotificationSender;
import com.stratelia.silverpeas.notificationManager.constant.NotifMediaType;
import com.stratelia.silverpeas.notificationManager.constant.NotifMessageType;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultUserNotification
implements UserNotification {
    private NotificationMetaData notification;

    public DefaultUserNotification() {
        this(null, null);
    }

    public DefaultUserNotification(String title, String content) {
        this.notification = StringUtils.isNotBlank((CharSequence)title) && StringUtils.isNotBlank((CharSequence)content) ? new NotificationMetaData(NotifMessageType.NORMAL.getId(), title, content) : new NotificationMetaData();
    }

    public DefaultUserNotification(String title, Map<String, SilverpeasTemplate> templates, String content) {
        this.notification = new NotificationMetaData(NotifMessageType.NORMAL.getId(), title, templates, content);
    }

    @Override
    public NotificationMetaData getNotificationMetaData() {
        return this.notification;
    }

    @Override
    public void send() {
        this.send(null);
    }

    @Override
    public void send(NotifMediaType mediaType) {
        if (this.notification != null) {
            try {
                NotificationSender sender = new NotificationSender(this.notification.getComponentId());
                if (mediaType != null) {
                    sender.notifyUser(mediaType.getId(), this.notification);
                } else {
                    sender.notifyUser(this.notification);
                }
            }
            catch (NotificationManagerException e) {
                SilverTrace.warn("notification", "IUserNotification.send()", "notification.EX_IMPOSSIBLE_DALERTER_LES_UTILISATEURS", "componentId=" + this.notification.getComponentId(), e);
            }
        }
    }
}

