/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.delayed.model;

import com.silverpeas.notification.delayed.constant.DelayedNotificationFrequency;
import com.silverpeas.notification.delayed.model.DelayedNotificationData;
import com.stratelia.silverpeas.notificationManager.constant.NotifChannel;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;

@Entity
@Table(name="st_delayednotifusersetting")
public class DelayedNotificationUserSetting
implements Serializable {
    private static final long serialVersionUID = 3477090528448919931L;
    @Id
    @TableGenerator(name="UNIQUE_ID_GEN", table="uniqueId", pkColumnName="tablename", valueColumnName="maxId", pkColumnValue="st_delayednotifusersetting", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="UNIQUE_ID_GEN")
    @Column(name="id")
    private Integer id;
    @Column(name="userId", nullable=false)
    private Integer userId;
    @Column(name="channel", nullable=false)
    private Integer channel;
    @Column(name="frequency", nullable=false)
    private String frequency;
    @OneToMany(mappedBy="delayedNotificationUserSetting", fetch=FetchType.LAZY)
    private List<DelayedNotificationData> delayedNotifications;

    public DelayedNotificationUserSetting() {
    }

    public DelayedNotificationUserSetting(int userId, NotifChannel channelId, DelayedNotificationFrequency frequency) {
        this.setUserId(userId);
        this.setChannel(channelId);
        this.setFrequency(frequency);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public NotifChannel getChannel() {
        return NotifChannel.decode(this.channel);
    }

    public void setChannel(NotifChannel channelId) {
        this.channel = channelId.getId();
    }

    public DelayedNotificationFrequency getFrequency() {
        return DelayedNotificationFrequency.decode(this.frequency);
    }

    public void setFrequency(DelayedNotificationFrequency frequency) {
        this.frequency = frequency.getCode();
    }

    public List<DelayedNotificationData> getDelayedNotifications() {
        return this.delayedNotifications;
    }

    public void setDelayedNotifications(List<DelayedNotificationData> delayedNotifications) {
        this.delayedNotifications = delayedNotifications;
    }
}

