/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.jms;

import com.silverpeas.notification.MessageSubscribingService;
import com.silverpeas.notification.NotificationSubscriber;
import com.silverpeas.notification.NotificationTopic;
import com.silverpeas.notification.SubscriptionException;
import com.silverpeas.notification.jms.ManagedTopicsSubscriber;
import com.silverpeas.notification.jms.SilverpeasMessageListener;
import com.silverpeas.notification.jms.access.ConnectionFailureListener;
import com.silverpeas.notification.jms.access.JMSAccessObject;
import com.silverpeas.util.ExecutionAttempts;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;

@Named(value="messageSubscribingService")
public class JMSSubscribingService
implements MessageSubscribingService,
ConnectionFailureListener {
    @Inject
    private JMSAccessObject jmsService;

    @PostConstruct
    public void initialize() {
        this.jmsService.addConnectionFailureListener(this);
    }

    @Override
    public synchronized void subscribe(final NotificationSubscriber subscriber, NotificationTopic onTopic) {
        final String topicName = onTopic.getName();
        String subscriberId = subscriber.getId();
        ManagedTopicsSubscriber existingTopicsSubscriber = ManagedTopicsSubscriber.getManagedTopicsSubscriberById(subscriberId);
        final ManagedTopicsSubscriber topicsSubscriber = existingTopicsSubscriber == null ? ManagedTopicsSubscriber.getNewManagedTopicsSubscriber() : existingTopicsSubscriber;
        try {
            ExecutionAttempts.retry(2, new ExecutionAttempts.Job(){

                @Override
                public void execute() throws Exception {
                    if (!topicsSubscriber.isSubscribedTo(topicName)) {
                        String id = topicsSubscriber.getId();
                        SilverpeasMessageListener listener = SilverpeasMessageListener.mapMessageListenerTo(subscriber).forTopic(topicName);
                        JMSSubscribingService.this.createSubscription(topicsSubscriber, topicName, listener);
                        topicsSubscriber.save();
                        subscriber.setId(id);
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new SubscriptionException(ex);
        }
    }

    @Override
    public synchronized void unsubscribe(NotificationSubscriber subscriber, final NotificationTopic fromTopic) {
        final ManagedTopicsSubscriber topicsSubscriber = ManagedTopicsSubscriber.getManagedTopicsSubscriberById(subscriber.getId());
        try {
            ExecutionAttempts.retry(2, new ExecutionAttempts.Job(){

                @Override
                public void execute() throws Exception {
                    TopicSubscriber jmsSubscriber;
                    if (topicsSubscriber != null && (jmsSubscriber = topicsSubscriber.getSubscription(fromTopic.getName())) != null) {
                        JMSSubscribingService.this.jmsService.disposeTopicSubscriber(jmsSubscriber);
                        topicsSubscriber.removeSubscription(jmsSubscriber);
                        if (topicsSubscriber.hasNoSusbscriptions()) {
                            topicsSubscriber.delete();
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new SubscriptionException(ex);
        }
    }

    @Override
    public void onConnectionFailure() {
        Logger.getLogger(this.getClass().getSimpleName()).log(Level.WARNING, "Connection failure detected: the subscriptions on the topics are lost. I'm going to recreate the subscriptions");
        Collection<ManagedTopicsSubscriber> subscribers = ManagedTopicsSubscriber.getAllManagedTopicSubscribers();
        for (final ManagedTopicsSubscriber subscriber : subscribers) {
            Collection<TopicSubscriber> subscriptions = subscriber.getAllSubscriptions();
            for (final TopicSubscriber subscription : subscriptions) {
                try {
                    ExecutionAttempts.retry(2, new ExecutionAttempts.Job(){

                        @Override
                        public void execute() throws Exception {
                            MessageListener listener = subscription.getMessageListener();
                            String topicName = subscription.getTopic().getTopicName();
                            JMSSubscribingService.this.createSubscription(subscriber, topicName, listener);
                            subscriber.removeSubscription(subscription);
                        }
                    });
                }
                catch (Exception ex) {
                    try {
                        String topicName = subscription.getTopic().getTopicName();
                        Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, "The subscription on '" + topicName + "' topic has failed!\n" + ex.getMessage());
                    }
                    catch (JMSException e) {
                        Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, "The subscription on a topic has failed!\n" + ex.getMessage());
                    }
                }
            }
        }
    }

    private String getSubscriptionId(ManagedTopicsSubscriber subscriber, String topicName) {
        return subscriber.getId() + "::" + topicName;
    }

    private void createSubscription(ManagedTopicsSubscriber subscriber, String topicName, MessageListener listener) throws NamingException, JMSException {
        String subscriptionId = this.getSubscriptionId(subscriber, topicName);
        TopicSubscriber jmsSubscriber = this.jmsService.createTopicSubscriber(topicName, subscriptionId, listener);
        subscriber.addSubscription(jmsSubscriber);
    }
}

