/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="st_notificationresource")
public class NotificationResourceData
implements Cloneable {
    public static final String LOCATION_SEPARATOR = "@#@#@";
    @Id
    @TableGenerator(name="UNIQUE_ID_GEN", table="uniqueId", pkColumnName="tablename", valueColumnName="maxId", pkColumnValue="st_notificationresource", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="UNIQUE_ID_GEN")
    @Column(name="id")
    private Long id;
    @Column(name="resourceId", nullable=false)
    private String resourceId;
    @Column(name="resourceType", nullable=false)
    private String resourceType;
    @Column(name="resourceName", nullable=false)
    private String resourceName;
    @Column(name="resourceDescription", nullable=true)
    private String resourceDescription;
    @Column(name="resourceLocation", nullable=false)
    private String resourceLocation;
    @Column(name="resourceUrl", nullable=true)
    private String resourceUrl;
    @Column(name="componentInstanceId", nullable=false)
    private String componentInstanceId;

    public void fillFrom(NotificationResourceData notificationResourceData) {
        this.setResourceId(notificationResourceData.getResourceId());
        this.setResourceType(notificationResourceData.getResourceType());
        this.setResourceName(notificationResourceData.getResourceName());
        this.setResourceDescription(notificationResourceData.getResourceDescription());
        this.setResourceLocation(notificationResourceData.getResourceLocation());
        this.setResourceUrl(notificationResourceData.getResourceUrl());
        this.setComponentInstanceId(notificationResourceData.getComponentInstanceId());
    }

    @PrePersist
    public void beforePersist() {
        this.forcesNullValues();
    }

    @PreUpdate
    public void beforeUpdate() {
        this.forcesNullValues();
    }

    private void forcesNullValues() {
        if (StringUtils.isBlank((String)this.resourceDescription)) {
            this.resourceDescription = null;
        }
        if (StringUtils.isBlank((String)this.resourceUrl)) {
            this.resourceUrl = null;
        }
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((String)this.resourceId) && StringUtils.isNotBlank((String)this.resourceType) && StringUtils.isNotBlank((String)this.resourceName) && StringUtils.isNotBlank((String)this.resourceLocation) && StringUtils.isNotBlank((String)this.resourceUrl) && StringUtils.isNotBlank((String)this.componentInstanceId);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(Number resourceId) {
        this.setResourceId((Object)resourceId);
    }

    public void setResourceId(String resourceId) {
        this.setResourceId((Object)resourceId);
    }

    private void setResourceId(Object resourceId) {
        this.resourceId = resourceId != null ? resourceId.toString() : null;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = resourceDescription;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public void setComponentInstanceId(String componentInstanceId) {
        this.componentInstanceId = componentInstanceId;
    }

    public NotificationResourceData clone() {
        NotificationResourceData clone;
        try {
            clone = (NotificationResourceData)super.clone();
            clone.setId(null);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getCause());
        }
        return clone;
    }
}

