/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.scheduler.simple;

import com.silverpeas.scheduler.JobExecutionContext;
import com.silverpeas.scheduler.ScheduledJob;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerException;
import com.silverpeas.scheduler.simple.SimpleScheduler;
import com.silverpeas.scheduler.trigger.CronJobTrigger;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.time.FastDateFormat;

@Deprecated
public abstract class SchedulerJob
implements Runnable,
ScheduledJob {
    protected Format logDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm");
    private SchedulerEventListener theOwner;
    private String sJobName;
    private List<Integer> vMinutes;
    private List<Integer> vHours;
    private List<Integer> vDaysOfMonth;
    private List<Integer> vMonths;
    private List<Integer> vDaysOfWeek;
    private Integer currentMinute;
    private Integer currentHour;
    private Integer currentDayOfMonth;
    private Integer currentMonth;
    private Integer currentYear;
    private long nextTimeStamp = 0L;
    private volatile boolean bRunnable;
    private JobTrigger trigger;

    public SchedulerEventListener getOwner() {
        return this.theOwner;
    }

    public void initTimeStamp(long nextTime) {
        this.nextTimeStamp = nextTime != 0L ? nextTime : this.getNextTimeStamp();
    }

    public long readNextTimeStamp() {
        return this.nextTimeStamp;
    }

    @Override
    public Date getNextExecutionTime() {
        return new Date(this.nextTimeStamp);
    }

    @Override
    public long getNexExecutionTimeInMillis() {
        return this.nextTimeStamp;
    }

    public String getJobName() {
        return this.sJobName;
    }

    @Override
    public void run() {
        if (this.nextTimeStamp == 0L) {
            this.nextTimeStamp = this.getNextTimeStamp();
        }
        SilverTrace.info("scheduler", "SchedulerJob.run", "root.MSG_GEN_PARAM_VALUE", ": Job '" + this.sJobName + "' starts without errors.");
        SilverTrace.info("scheduler", "SchedulerJob.run", "root.MSG_GEN_PARAM_VALUE", ": Next schedule time: " + this.logDateFormat.format(new Date(this.nextTimeStamp)));
        while (this.bRunnable) {
            try {
                long sleepTime = this.nextTimeStamp - new Date().getTime();
                SilverTrace.info("scheduler", "SchedulerJob.run", "root.MSG_GEN_PARAM_VALUE", ": Sleeptime = " + sleepTime);
                if (sleepTime < 0L) {
                    Thread.currentThread();
                    Thread.sleep(0L);
                } else {
                    Thread.currentThread();
                    Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException aException) {
                // empty catch block
            }
            if (!this.bRunnable || new Date().getTime() < this.nextTimeStamp) continue;
            try {
                SilverTrace.info("scheduler", "SchedulerJob.run", "root.MSG_GEN_PARAM_VALUE", ": ---------------- Start of job '" + this.sJobName + "' -------------------");
                this.nextTimeStamp = this.getNextTimeStamp();
                Date now = new Date();
                JobExecutionContext ctx = JobExecutionContext.createWith(this.sJobName, now);
                try {
                    this.execute(now);
                    this.theOwner.jobSucceeded(SchedulerEvent.jobSucceeded(ctx));
                }
                catch (SchedulerException aException) {
                    this.theOwner.jobFailed(SchedulerEvent.jobFailed(ctx, aException));
                }
                SilverTrace.info("scheduler", "SchedulerJob.run", "root.MSG_GEN_PARAM_VALUE", ": ---------------- End of job '" + this.sJobName + "' -------------------");
                SilverTrace.info("scheduler", "SchedulerJob.run", "root.MSG_GEN_PARAM_VALUE", ": Next schedule time: " + this.logDateFormat.format(new Date(this.nextTimeStamp)));
            }
            catch (Exception aException) {
                SilverTrace.error("scheduler", "SchedulerJob.run", "root.EX_NO_MESSAGE", aException);
            }
        }
        this.theOwner = null;
        this.sJobName = null;
    }

    public synchronized void stop() {
        this.bRunnable = false;
    }

    protected abstract void execute(Date var1) throws SchedulerException;

    protected SchedulerJob(SimpleScheduler aController, SchedulerEventListener aOwner, String aJobName) throws SchedulerException {
        if (aController == null) {
            throw new SchedulerException("SchedulerJob.SchedulerJob: Parameter 'aController' is null");
        }
        if (aOwner == null) {
            throw new SchedulerException("SchedulerJob.SchedulerJob: Parameter 'aOwner' is null");
        }
        if (aJobName == null) {
            throw new SchedulerException("SchedulerJob.SchedulerJob: Parameter 'aJobName' is null");
        }
        this.theOwner = aOwner;
        this.sJobName = aJobName;
        this.vMinutes = new ArrayList<Integer>();
        this.vHours = new ArrayList<Integer>();
        this.vDaysOfMonth = new ArrayList<Integer>();
        this.vMonths = new ArrayList<Integer>();
        this.vDaysOfWeek = new ArrayList<Integer>();
        Calendar calInit = Calendar.getInstance();
        this.currentMinute = 0;
        this.currentHour = 0;
        if (calInit.getActualMinimum(5) == calInit.get(5)) {
            this.currentDayOfMonth = calInit.getActualMaximum(5);
            if (calInit.getActualMinimum(2) == calInit.get(2)) {
                this.currentMonth = calInit.getActualMaximum(2);
                this.currentYear = calInit.get(1) - 1;
            } else {
                this.currentMonth = calInit.get(2) - 1;
                this.currentYear = calInit.get(1);
            }
        } else {
            this.currentDayOfMonth = calInit.get(5) - 1;
            this.currentMonth = calInit.get(2);
            this.currentYear = calInit.get(1);
        }
        if (calInit.getActualMinimum(2) == this.currentMonth.intValue()) {
            this.currentMonth = calInit.getActualMaximum(2);
            this.currentYear = this.currentYear - 1;
        } else {
            this.currentMonth = this.currentMonth - 1;
        }
        this.nextTimeStamp = 0L;
        this.bRunnable = true;
    }

    protected synchronized void setSchedulingParameter(List<Integer> startMinutes, List<Integer> startHours, List<Integer> startDaysOfMonth, List<Integer> startMonths, List<Integer> startDaysOfWeek) throws SchedulerException {
        int workInt;
        if (startMinutes == null) {
            startMinutes = new ArrayList<Integer>();
        }
        for (Integer minute : startMinutes) {
            try {
                workInt = minute;
                if (workInt >= 0 && workInt <= 59) continue;
                throw new SchedulerException("SchedulerMethodJob.setParameter: A minute value is out of range");
            }
            catch (ClassCastException aException) {
                throw new SchedulerException("SchedulerMethodJob.setParameter: Can't convert a minute value");
            }
        }
        if (startHours == null) {
            startHours = new ArrayList<Integer>();
        }
        for (Integer hours : startHours) {
            try {
                workInt = hours;
                if (workInt >= 0 && workInt <= 23) continue;
                throw new SchedulerException("SchedulerMethodJob.setParameter: A hour value is out of range");
            }
            catch (ClassCastException aException) {
                throw new SchedulerException("SchedulerMethodJob.setParameter: Can't convert a hour value");
            }
        }
        if (startDaysOfMonth == null) {
            startDaysOfMonth = new ArrayList<Integer>();
        }
        for (Integer days : startDaysOfMonth) {
            try {
                workInt = days;
                if (workInt >= 1 && workInt <= 31) continue;
                throw new SchedulerException("SchedulerMethodJob.setParameter: A day of month value is out of range");
            }
            catch (ClassCastException aException) {
                throw new SchedulerException("SchedulerMethodJob.setParameter: Can't convert a day of month value");
            }
        }
        if (startMonths == null) {
            startMonths = new ArrayList<Integer>();
        }
        ArrayList<Integer> workVector = new ArrayList<Integer>();
        for (Integer month : startMonths) {
            try {
                workInt = month;
                if (workInt < 1 || workInt > 12) {
                    throw new SchedulerException("SchedulerMethodJob.setParameter: A month value is out of range");
                }
                workVector.add(workInt - 1);
            }
            catch (ClassCastException aException) {
                throw new SchedulerException("SchedulerMethodJob.setParameter: Can't convert a month value");
            }
        }
        startMonths = workVector;
        if (startDaysOfWeek == null) {
            startDaysOfWeek = new ArrayList<Integer>();
        }
        workVector = new ArrayList();
        for (Integer daysOfWeek : startDaysOfWeek) {
            try {
                workInt = daysOfWeek;
                if (workInt < 0 || workInt > 6) {
                    throw new SchedulerException("SchedulerMethodJob.setParameter: A day of week value is out of range");
                }
                switch (workInt) {
                    case 0: {
                        workVector.add(1);
                        break;
                    }
                    case 1: {
                        workVector.add(2);
                        break;
                    }
                    case 2: {
                        workVector.add(3);
                        break;
                    }
                    case 3: {
                        workVector.add(4);
                        break;
                    }
                    case 4: {
                        workVector.add(5);
                        break;
                    }
                    case 5: {
                        workVector.add(6);
                        break;
                    }
                    case 6: {
                        workVector.add(7);
                    }
                }
            }
            catch (ClassCastException aException) {
                throw new SchedulerException("SchedulerMethodJob.setParameter: Can't convert a day of week value");
            }
        }
        startDaysOfWeek = workVector;
        this.vMinutes = startMinutes;
        this.vHours = startHours;
        this.vDaysOfMonth = startDaysOfMonth;
        this.vMonths = startMonths;
        this.vDaysOfWeek = startDaysOfWeek;
        this.sortCronVectors();
    }

    protected synchronized void setSchedulingParameter(CronJobTrigger trigger) throws SchedulerException {
        int workInt;
        String workString;
        StringTokenizer fieldContentSeparator;
        this.setTrigger(trigger);
        String aCronString = trigger.getCronExpression();
        if (aCronString == null) {
            throw new SchedulerException("SchedulerShellJob.setCronString: Parameter 'aCronString' is null");
        }
        if (aCronString.contains("-") || aCronString.contains("/")) {
            throw new SchedulerException("This scheduler backend doesn't support yet the range and the increment instructions in cron expressions");
        }
        aCronString = aCronString.replaceAll("\\?", "*");
        this.vMinutes = new ArrayList<Integer>();
        this.vHours = new ArrayList<Integer>();
        this.vDaysOfMonth = new ArrayList<Integer>();
        this.vMonths = new ArrayList<Integer>();
        this.vDaysOfWeek = new ArrayList<Integer>();
        StringTokenizer fieldSeparator = new StringTokenizer(aCronString);
        if (fieldSeparator.hasMoreTokens()) {
            fieldContentSeparator = new StringTokenizer(fieldSeparator.nextToken(), ",");
            while (fieldContentSeparator.hasMoreTokens()) {
                workString = fieldContentSeparator.nextToken();
                if (workString.equals("*")) {
                    this.vMinutes = new ArrayList<Integer>();
                    break;
                }
                try {
                    workInt = Integer.parseInt(workString);
                }
                catch (NumberFormatException aException) {
                    throw new SchedulerException("SchedulerShellJob.setCronString: Can't convert a minute value");
                }
                if (workInt < 0 || workInt > 59) {
                    throw new SchedulerException("SchedulerShellJob.setCronString: A minute value is out of range");
                }
                this.vMinutes.add(workInt);
            }
        }
        if (fieldSeparator.hasMoreTokens()) {
            fieldContentSeparator = new StringTokenizer(fieldSeparator.nextToken(), ",");
            while (fieldContentSeparator.hasMoreTokens()) {
                workString = fieldContentSeparator.nextToken();
                if (workString.equals("*")) {
                    this.vHours = new ArrayList<Integer>();
                    break;
                }
                try {
                    workInt = Integer.parseInt(workString);
                }
                catch (NumberFormatException aException) {
                    throw new SchedulerException("SchedulerShellJob.setCronString: Can't convert a hour value");
                }
                if (workInt < 0 || workInt > 23) {
                    throw new SchedulerException("SchedulerShellJob.setCronString: A hour value is out of range");
                }
                this.vHours.add(workInt);
            }
        }
        if (fieldSeparator.hasMoreTokens()) {
            fieldContentSeparator = new StringTokenizer(fieldSeparator.nextToken(), ",");
            while (fieldContentSeparator.hasMoreTokens()) {
                workString = fieldContentSeparator.nextToken();
                if (workString.equals("*")) {
                    this.vDaysOfMonth = new ArrayList<Integer>();
                    break;
                }
                try {
                    workInt = Integer.parseInt(workString);
                }
                catch (NumberFormatException aException) {
                    throw new SchedulerException("SchedulerShellJob.setCronString: Can't convert a day of month value");
                }
                if (workInt < 1 || workInt > 31) {
                    throw new SchedulerException("SchedulerShellJob.setCronString: A day of month value is out of range");
                }
                this.vDaysOfMonth.add(workInt);
            }
        }
        if (fieldSeparator.hasMoreTokens()) {
            fieldContentSeparator = new StringTokenizer(fieldSeparator.nextToken(), ",");
            while (fieldContentSeparator.hasMoreTokens()) {
                workString = fieldContentSeparator.nextToken();
                if (workString.equals("*")) {
                    this.vMonths = new ArrayList<Integer>();
                    break;
                }
                try {
                    workInt = Integer.parseInt(workString);
                }
                catch (NumberFormatException aException) {
                    throw new SchedulerException("SchedulerShellJob.setCronString: Can't convert a month value");
                }
                if (workInt < 1 || workInt > 12) {
                    throw new SchedulerException("SchedulerShellJob.setCronString: A month value is out of range");
                }
                this.vMonths.add(workInt - 1);
            }
        }
        if (fieldSeparator.hasMoreTokens()) {
            fieldContentSeparator = new StringTokenizer(fieldSeparator.nextToken(), ",");
            while (fieldContentSeparator.hasMoreTokens()) {
                workString = fieldContentSeparator.nextToken();
                if (workString.equals("*")) {
                    this.vDaysOfWeek = new ArrayList<Integer>();
                    break;
                }
                try {
                    workInt = Integer.parseInt(workString);
                }
                catch (NumberFormatException aException) {
                    throw new SchedulerException("SchedulerShellJob.setCronString: Can't convert a day of week value");
                }
                if (workInt < 0 || workInt > 6) {
                    throw new SchedulerException("SchedulerShellJob.setCronString: A day of week value is out of range");
                }
                switch (workInt) {
                    case 0: {
                        this.vDaysOfWeek.add(1);
                        break;
                    }
                    case 1: {
                        this.vDaysOfWeek.add(2);
                        break;
                    }
                    case 2: {
                        this.vDaysOfWeek.add(3);
                        break;
                    }
                    case 3: {
                        this.vDaysOfWeek.add(4);
                        break;
                    }
                    case 4: {
                        this.vDaysOfWeek.add(5);
                        break;
                    }
                    case 5: {
                        this.vDaysOfWeek.add(6);
                        break;
                    }
                    case 6: {
                        this.vDaysOfWeek.add(7);
                    }
                }
            }
        }
        if (fieldSeparator.hasMoreTokens()) {
            throw new SchedulerException("SchedulerShellJob.setCronString: Too much time fields in cron string");
        }
        if (this.vDaysOfWeek == null) {
            throw new SchedulerException("SchedulerShellJob.setCronString: Not enough time fields in cron string");
        }
        this.sortCronVectors();
    }

    protected long getNextTimeStamp() {
        Calendar calcCalendar = Calendar.getInstance();
        SilverTrace.debug("scheduler", "SchedulerJob.getNextTimeStamp", "Current TimeStamp: " + this.logDateFormat.format(new Date(this.getMillisecondsOfCalendar(calcCalendar))));
        long currentTime = this.getMillisecondsOfCalendar(calcCalendar);
        calcCalendar.set(1, this.currentYear);
        calcCalendar.set(2, this.currentMonth);
        calcCalendar.set(5, this.currentDayOfMonth);
        calcCalendar.set(11, this.currentHour);
        calcCalendar.set(12, this.currentMinute);
        SilverTrace.debug("scheduler", "SchedulerJob.getNextTimeStamp", "Start TimeStamp: " + this.logDateFormat.format(new Date(this.getMillisecondsOfCalendar(calcCalendar))));
        boolean validTimeStamp = false;
        boolean carryMinute = false;
        boolean carryHour = false;
        boolean carryDayOfMonth = false;
        boolean carryMonth = false;
        boolean firstYearAccess = true;
        block0: while (!validTimeStamp) {
            int indexOfMonths;
            int maxMonth;
            if (this.vMinutes.isEmpty()) {
                carryMinute = true;
            } else if (this.vMinutes.size() == 1) {
                this.currentMinute = this.vMinutes.get(0);
                boolean bl = carryMinute = !carryMinute;
                if (!carryMinute) {
                    carryHour = false;
                    carryDayOfMonth = false;
                    carryMonth = false;
                }
            } else {
                int indexOfMinutes = this.vMinutes.indexOf(this.currentMinute);
                if (indexOfMinutes == -1 || indexOfMinutes == this.vMinutes.size() - 1) {
                    this.currentMinute = this.vMinutes.get(0);
                    carryMinute = true;
                } else {
                    this.currentMinute = this.vMinutes.get(indexOfMinutes + 1);
                    carryMinute = false;
                    carryHour = false;
                    carryDayOfMonth = false;
                    carryMonth = false;
                }
            }
            calcCalendar.set(12, this.currentMinute);
            if (carryMinute) {
                if (this.vHours.isEmpty()) {
                    int maxHour = calcCalendar.getActualMaximum(11);
                    if (this.currentHour < maxHour) {
                        this.currentHour = this.currentHour + 1;
                        carryHour = false;
                        carryDayOfMonth = false;
                        carryMonth = false;
                    } else {
                        this.currentHour = calcCalendar.getActualMinimum(11);
                        carryHour = true;
                    }
                } else if (this.vHours.size() == 1) {
                    this.currentHour = this.vHours.get(0);
                    boolean bl = carryHour = !carryHour;
                    if (!carryHour) {
                        carryDayOfMonth = false;
                        carryMonth = false;
                    }
                } else {
                    int indexOfHours = this.vHours.indexOf(this.currentHour);
                    if (indexOfHours == -1 || indexOfHours == this.vHours.size() - 1) {
                        this.currentHour = this.vHours.get(0);
                        carryHour = true;
                    } else {
                        this.currentHour = this.vHours.get(indexOfHours + 1);
                        carryHour = false;
                        carryDayOfMonth = false;
                        carryMonth = false;
                    }
                }
                calcCalendar.set(11, this.currentHour);
            }
            if (carryHour) {
                if (this.vDaysOfMonth.isEmpty()) {
                    maxMonth = calcCalendar.getActualMaximum(5);
                    if (this.currentDayOfMonth < maxMonth) {
                        this.currentDayOfMonth = this.currentDayOfMonth + 1;
                        carryDayOfMonth = false;
                        carryMonth = false;
                    } else {
                        this.currentDayOfMonth = calcCalendar.getActualMinimum(5);
                        carryDayOfMonth = true;
                    }
                } else if (this.vMinutes.size() == 1) {
                    this.currentDayOfMonth = this.vDaysOfMonth.get(0);
                    boolean bl = carryDayOfMonth = !carryDayOfMonth;
                    if (!carryDayOfMonth) {
                        carryMonth = false;
                    }
                } else {
                    indexOfMonths = this.vDaysOfMonth.indexOf(this.currentDayOfMonth);
                    if (indexOfMonths == -1 || indexOfMonths == this.vDaysOfMonth.size() - 1) {
                        this.currentDayOfMonth = this.vDaysOfMonth.get(0);
                        carryDayOfMonth = true;
                    } else {
                        this.currentDayOfMonth = this.vDaysOfMonth.get(indexOfMonths + 1);
                        carryDayOfMonth = false;
                        carryMonth = false;
                    }
                }
                calcCalendar.set(5, this.currentDayOfMonth);
            }
            if (carryDayOfMonth) {
                if (this.vMonths.isEmpty()) {
                    maxMonth = calcCalendar.getActualMaximum(2);
                    if (this.currentMonth < maxMonth) {
                        this.currentMonth = this.currentMonth + 1;
                        carryMonth = false;
                    } else {
                        this.currentMonth = calcCalendar.getActualMinimum(2);
                        carryMonth = true;
                    }
                } else if (this.vMinutes.size() == 1) {
                    this.currentMonth = this.vMonths.get(0);
                    carryMonth = !carryMonth;
                } else {
                    indexOfMonths = this.vMonths.indexOf(this.currentMonth);
                    if (indexOfMonths == -1 || indexOfMonths == this.vMonths.size() - 1) {
                        this.currentMonth = this.vMonths.get(0);
                        carryMonth = true;
                    } else {
                        this.currentMonth = this.vMonths.get(indexOfMonths + 1);
                        carryMonth = false;
                    }
                }
                calcCalendar.set(2, this.currentMonth);
            }
            if (carryMonth) {
                if (!firstYearAccess || this.currentMinute == 0 && this.currentHour == 0 && this.currentDayOfMonth == 1 && this.currentMonth == 0) {
                    this.currentYear = this.currentYear + 1;
                    calcCalendar.set(1, this.currentYear);
                }
                firstYearAccess = false;
            }
            if (this.getMillisecondsOfCalendar(calcCalendar) <= currentTime || calcCalendar.get(5) != this.currentDayOfMonth.intValue()) continue;
            if (this.vDaysOfWeek.isEmpty()) {
                validTimeStamp = true;
                continue;
            }
            for (Integer dayOfWeek : this.vDaysOfWeek) {
                if (calcCalendar.get(7) != dayOfWeek.intValue()) continue;
                validTimeStamp = true;
                continue block0;
            }
        }
        SilverTrace.debug("scheduler", "SchedulerJob.getNextTimeStamp", "New TimeStamp: " + this.logDateFormat.format(new Date(this.getMillisecondsOfCalendar(calcCalendar))));
        return this.getMillisecondsOfCalendar(calcCalendar);
    }

    protected long getMillisecondsOfCalendar(Calendar aCalendar) {
        return aCalendar.getTime().getTime();
    }

    private void sortCronVectors() {
        Collections.sort(this.vMinutes);
        Collections.sort(this.vHours);
        Collections.sort(this.vDaysOfMonth);
        Collections.sort(this.vMonths);
        Collections.sort(this.vDaysOfWeek);
        this.removeDoubled(this.vMinutes);
        this.removeDoubled(this.vHours);
        this.removeDoubled(this.vDaysOfMonth);
        this.removeDoubled(this.vMonths);
        this.removeDoubled(this.vDaysOfWeek);
    }

    private void removeDoubled(List<? extends Comparable> aList) {
        Comparable lastComparable = null;
        Iterator<? extends Comparable> listIterator = aList.iterator();
        while (listIterator.hasNext()) {
            try {
                if (lastComparable == null) {
                    lastComparable = listIterator.next();
                    continue;
                }
                Comparable currentComparable = listIterator.next();
                if (lastComparable.compareTo(currentComparable) == 0) {
                    listIterator.remove();
                    continue;
                }
                lastComparable = currentComparable;
            }
            catch (Exception aException) {}
        }
    }

    @Override
    public String getName() {
        return this.getJobName();
    }

    @Override
    public void execute(JobExecutionContext context) throws Exception {
        this.execute(new Date());
    }

    @Override
    public SchedulerEventListener getSchedulerEventListener() {
        return this.getOwner();
    }

    @Override
    public JobTrigger getTrigger() {
        return this.trigger;
    }

    protected void setTrigger(JobTrigger trigger) {
        this.trigger = trigger;
    }
}

