/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.model;

import com.silverpeas.calendar.DateTime;
import com.silverpeas.socialnetwork.model.SocialInformation;
import java.util.Date;

public abstract class AbstractSocialInformation
implements SocialInformation {
    protected String title;
    protected String description;
    protected String author;
    protected String url;
    protected Date date;
    protected boolean socialInformationWasupdated;
    protected String type;
    protected String icon;

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public boolean isUpdated() {
        return this.socialInformationWasupdated;
    }

    @Override
    public void setUpdated(boolean updated) {
        this.socialInformationWasupdated = updated;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (this.isUpdated()) {
            return this.type + "_update.gif";
        }
        return this.type + "_new.gif";
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSocialInformation other = (AbstractSocialInformation)obj;
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return this.date == other.date || this.date != null && this.date.equals(other.date);
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.title != null ? this.title.hashCode() : 0);
        hash = 71 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 71 * hash + (this.author != null ? this.author.hashCode() : 0);
        hash = 71 * hash + (this.url != null ? this.url.hashCode() : 0);
        hash = 71 * hash + (this.date != null ? this.date.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(SocialInformation o) {
        DateTime myDate = new DateTime(this.getDate());
        DateTime otherDate = new DateTime(o.getDate());
        int result = ((DateTime)otherDate.getBeginOfDay()).compareTo((Date)myDate.getBeginOfDay());
        if (result == 0 && (result = this.getUrl().compareTo(o.getUrl())) == 0) {
            boolean myIsComment = this.getType().contains("COMMENT");
            boolean otherIsComment = o.getType().contains("COMMENT");
            if (!myIsComment && otherIsComment || myIsComment && !otherIsComment) {
                int n = result = myIsComment ? -1 : 1;
            }
        }
        if (result == 0) {
            if (this.isUpdated() && !o.isUpdated()) {
                result = -1;
            } else if (!this.isUpdated() && o.isUpdated()) {
                result = 1;
            }
        }
        return result;
    }
}

