/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.status;

import com.silverpeas.calendar.Date;
import com.silverpeas.socialnetwork.model.SocialInformation;
import com.silverpeas.socialnetwork.status.Status;
import com.silverpeas.socialnetwork.status.StatusDao;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;

public class StatusService {
    private StatusDao statusDao = new StatusDao();

    private Connection getConnection() throws UtilException {
        return DBUtil.makeConnection(JNDINames.DATABASE_DATASOURCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String changeStatusService(Status status) {
        Connection connection = null;
        int id = -1;
        try {
            connection = this.getConnection();
            id = this.statusDao.changeStatus(connection, status);
            if (id >= 0) {
                String string = status.getDescription();
                return string;
            }
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Status", "StatusService.changeStatus", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteStatusService(int id) {
        Connection connection = null;
        boolean delete_status = false;
        try {
            connection = this.getConnection();
            delete_status = this.statusDao.deleteStatus(connection, id);
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Status", "StatusService.deleteStatus", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return delete_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatusService(int id) {
        Connection connection = null;
        Status status = new Status();
        try {
            connection = this.getConnection();
            status = this.statusDao.getStatus(connection, id);
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Status", "StatusService.getStatus", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getLastStatusService(int userid) {
        Connection connection = null;
        Status status = new Status();
        try {
            connection = this.getConnection();
            status = this.statusDao.getLastStatus(connection, userid);
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Status", "StatusService.getLastStatus", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatusService(Status status) {
        Connection connection = null;
        boolean update_status = false;
        try {
            connection = this.getConnection();
            update_status = this.statusDao.updateStatus(connection, status);
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Status", "StatusService.UpdateStatus", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return update_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialInformation> getAllStatusService(int userId, Date begin, Date end) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            List<SocialInformation> list = this.statusDao.getAllStatus(connection, userId, begin, end);
            return list;
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Status", "StatusService.getAllStatus", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SocialInformation> getSocialInformationsListOfMyContacts(List<String> myContactsIds, Date begin, Date end) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            List<SocialInformation> list = this.statusDao.getSocialInformationsListOfMyContacts(connection, myContactsIds, begin, end);
            return list;
        }
        catch (Exception ex) {
            SilverTrace.error("Silverpeas.Bus.SocialNetwork.Status", "StatusService.getAllStatus", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return Collections.emptyList();
    }
}

