/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.thumbnail;

import com.silverpeas.util.StringUtil;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class ThumbnailSettings {
    protected static final int DEFAULT_SIZE = 150;
    protected static final String APP_PARAM_WIDTH = "thumbnailWidthSize";
    protected static final String APP_PARAM_HEIGHT = "thumbnailHeightSize";
    private static final String APP_PARAM_MANDATORY = "thumbnailMandatory";
    private boolean mandatory;
    private int width = -1;
    private int height = -1;

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public static ThumbnailSettings getInstance(String componentId, int defaultWidth, int defaultHeight) {
        ThumbnailSettings settings = new ThumbnailSettings();
        settings.setMandatory(StringUtil.getBooleanValue(ThumbnailSettings.getComponentParameterValue(APP_PARAM_MANDATORY, componentId)));
        int width = ThumbnailSettings.getInt(ThumbnailSettings.getComponentParameterValue(APP_PARAM_WIDTH, componentId));
        int height = ThumbnailSettings.getInt(ThumbnailSettings.getComponentParameterValue(APP_PARAM_HEIGHT, componentId));
        if (width == -1 && height == -1) {
            if (defaultWidth == -1 && defaultHeight == -1) {
                defaultHeight = 150;
                defaultWidth = 150;
            } else if (defaultWidth != -1 && defaultHeight == -1) {
                defaultHeight = defaultWidth;
            } else if (defaultWidth == -1 && defaultHeight != -1) {
                defaultWidth = defaultHeight;
            }
            width = defaultWidth;
            height = defaultHeight;
        } else if (width != -1 && height == -1) {
            height = width;
        } else if (width == -1 && height != -1) {
            width = height;
        }
        settings.setWidth(width);
        settings.setHeight(height);
        return settings;
    }

    private static String getComponentParameterValue(String parameterName, String componentId) {
        return OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(componentId, parameterName);
    }

    private static int getInt(String str) {
        if (StringUtil.isInteger(str)) {
            return Integer.parseInt(str);
        }
        return -1;
    }
}

