/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.thumbnail.control;

import com.silverpeas.thumbnail.ThumbnailException;
import com.silverpeas.thumbnail.ThumbnailRuntimeException;
import com.silverpeas.thumbnail.model.ThumbnailDetail;
import com.silverpeas.thumbnail.service.ThumbnailService;
import com.silverpeas.thumbnail.service.ThumbnailServiceFactory;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.ImageUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.file.SilverpeasFile;
import org.silverpeas.file.SilverpeasFileDescriptor;
import org.silverpeas.file.SilverpeasFileProvider;
import org.silverpeas.servlet.FileUploadUtil;

public class ThumbnailController {
    private static final ResourceLocator publicationSettings = new ResourceLocator("org.silverpeas.util.publication.publicationSettings", "fr");

    private static ThumbnailService getThumbnailService() {
        return ThumbnailServiceFactory.getThumbnailService();
    }

    public static boolean processThumbnail(ForeignPK pk, String objectType, List<FileItem> parameters) throws Exception {
        String nameImageFromGallery;
        String logicalName;
        boolean thumbnailChanged = false;
        String mimeType = null;
        String physicalName = null;
        FileItem uploadedFile = FileUploadUtil.getFile(parameters, "WAIMGVAR0");
        if (uploadedFile != null && StringUtil.isDefined(logicalName = uploadedFile.getName().replace('\\', '/'))) {
            logicalName = FilenameUtils.getName((String)logicalName);
            mimeType = FileUtil.getMimeType(logicalName);
            String type = FileRepositoryManager.getFileExtension(logicalName);
            if (FileUtil.isImage(logicalName)) {
                physicalName = String.valueOf(System.currentTimeMillis()) + '.' + type;
                SilverpeasFileDescriptor descriptor = new SilverpeasFileDescriptor(pk.getInstanceId()).mimeType(mimeType).parentDirectory(publicationSettings.getString("imagesSubDirectory")).fileName(physicalName);
                SilverpeasFile target = SilverpeasFileProvider.newFile(descriptor);
                target.writeFrom(uploadedFile.getInputStream());
            } else {
                throw new ThumbnailRuntimeException("ThumbnailController.processThumbnail()", 4, "thumbnail_EX_MSG_WRONG_TYPE_ERROR");
            }
        }
        if (physicalName == null && StringUtil.isDefined(nameImageFromGallery = FileUploadUtil.getParameter(parameters, "valueImageGallery"))) {
            physicalName = nameImageFromGallery;
            mimeType = "image/jpeg";
        }
        if (StringUtil.isDefined(physicalName)) {
            ThumbnailDetail detail = new ThumbnailDetail(pk.getInstanceId(), Integer.parseInt(pk.getId()), 1);
            detail.setOriginalFileName(physicalName);
            detail.setMimeType(mimeType);
            try {
                ThumbnailController.updateThumbnail(detail);
                thumbnailChanged = true;
            }
            catch (ThumbnailRuntimeException e) {
                SilverTrace.error("thumbnail", "KmeliaRequestRouter.processVignette", "thumbnail_MSG_UPDATE_THUMBNAIL_KO", e);
                try {
                    ThumbnailController.deleteThumbnail(detail);
                }
                catch (Exception exp) {
                    SilverTrace.info("thumbnail", "KmeliaRequestRouter.processVignette", "thumbnail_MSG_DELETE_THUMBNAIL_KO", exp);
                }
            }
        }
        return thumbnailChanged;
    }

    public static void updateThumbnail(ThumbnailDetail thumbDetail) {
        try {
            ThumbnailDetail completeThumbnail = ThumbnailController.getThumbnailService().getCompleteThumbnail(thumbDetail);
            if (completeThumbnail != null) {
                if (completeThumbnail.getCropFileName() != null) {
                    ThumbnailController.deleteThumbnailFileOnServer(completeThumbnail.getInstanceId(), completeThumbnail.getCropFileName());
                }
                ThumbnailController.getThumbnailService().deleteThumbnail(thumbDetail);
            }
            thumbDetail.setCropFileName(null);
            thumbDetail.setXLength(-1);
            thumbDetail.setXStart(-1);
            thumbDetail.setYLength(-1);
            thumbDetail.setYStart(-1);
            ThumbnailController.getThumbnailService().createThumbnail(thumbDetail);
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException("ThumbnailController.updateThumbnail()", 4, "thumbnail_MSG_UPDATE_THUMBNAIL_KO", e);
        }
    }

    public static void deleteThumbnail(ThumbnailDetail thumbDetail) {
        try {
            ThumbnailDetail completeThumbnail = ThumbnailController.getThumbnailService().getCompleteThumbnail(thumbDetail);
            if (completeThumbnail != null) {
                if (completeThumbnail.getOriginalFileName() != null) {
                    ThumbnailController.deleteThumbnailFileOnServer(completeThumbnail.getInstanceId(), completeThumbnail.getOriginalFileName());
                }
                if (completeThumbnail.getCropFileName() != null) {
                    ThumbnailController.deleteThumbnailFileOnServer(completeThumbnail.getInstanceId(), completeThumbnail.getCropFileName());
                }
                ThumbnailController.getThumbnailService().deleteThumbnail(thumbDetail);
            }
        }
        catch (Exception fe) {
            throw new ThumbnailRuntimeException("ThumbnailController.deleteThumbnail(ThumbnailDetail thumbDetail)", 4, "thumbnail_MSG_DELETE_THUMBNAIL_KO", fe);
        }
    }

    public static ThumbnailDetail createThumbnail(ThumbnailDetail thumbDetail, int thumbnailWidth, int thumbnailHeight) {
        try {
            ThumbnailDetail thumdAdded = ThumbnailController.getThumbnailService().createThumbnail(thumbDetail);
            if (thumdAdded.getCropFileName() == null && thumdAdded.isCropable()) {
                ThumbnailController.createCropFile(thumbnailWidth, thumbnailHeight, thumdAdded);
            }
            return thumdAdded;
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException("ThumbnailController.createThumbnail()", 4, "thumbnail_MSG_CREATE_THUMBNAIL_KO", e);
        }
    }

    public static ThumbnailDetail getCompleteThumbnail(ThumbnailDetail thumbDetail) {
        try {
            return ThumbnailController.getThumbnailService().getCompleteThumbnail(thumbDetail);
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException("ThumbnailController.getCompleteThumbnail()", 4, "thumbnail_MSG_GET_COMPLETE_THUMBNAIL_KO", e);
        }
    }

    public static void copyThumbnail(ForeignPK fromPK, ForeignPK toPK) {
        ThumbnailDetail vignette = ThumbnailController.getCompleteThumbnail(new ThumbnailDetail(fromPK.getInstanceId(), Integer.parseInt(fromPK.getId()), 1));
        try {
            if (vignette != null) {
                ThumbnailDetail thumbDetail = new ThumbnailDetail(toPK.getInstanceId(), Integer.valueOf(toPK.getId()), 1);
                if (vignette.getOriginalFileName().startsWith("/")) {
                    thumbDetail.setOriginalFileName(vignette.getOriginalFileName());
                    thumbDetail.setMimeType(vignette.getMimeType());
                } else {
                    String from = ThumbnailController.getImageDirectory(fromPK.getInstanceId()) + vignette.getOriginalFileName();
                    String type = FilenameUtils.getExtension((String)vignette.getOriginalFileName());
                    String newOriginalImage = String.valueOf(System.currentTimeMillis()) + "." + type;
                    String to = ThumbnailController.getImageDirectory(toPK.getInstanceId()) + newOriginalImage;
                    FileRepositoryManager.copyFile(from, to);
                    thumbDetail.setOriginalFileName(newOriginalImage);
                    if (vignette.getCropFileName() != null) {
                        from = ThumbnailController.getImageDirectory(fromPK.getInstanceId()) + vignette.getCropFileName();
                        type = FilenameUtils.getExtension((String)vignette.getCropFileName());
                        String newThumbnailImage = String.valueOf(System.currentTimeMillis()) + "." + type;
                        to = ThumbnailController.getImageDirectory(toPK.getInstanceId()) + newThumbnailImage;
                        FileRepositoryManager.copyFile(from, to);
                        thumbDetail.setCropFileName(newThumbnailImage);
                    }
                    thumbDetail.setMimeType(vignette.getMimeType());
                    thumbDetail.setXLength(vignette.getXLength());
                    thumbDetail.setYLength(vignette.getYLength());
                    thumbDetail.setXStart(vignette.getXStart());
                    thumbDetail.setYStart(vignette.getYStart());
                }
                ThumbnailController.getThumbnailService().createThumbnail(thumbDetail);
            }
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException("ThumbnailController.copyThumbnail()", 4, "thumbnail_CANT_COPY_THUMBNAIL", e);
        }
    }

    public static void moveThumbnail(ForeignPK fromPK, ForeignPK toPK) {
        ThumbnailDetail thumbnail = ThumbnailController.getCompleteThumbnail(new ThumbnailDetail(fromPK.getInstanceId(), Integer.parseInt(fromPK.getId()), 1));
        try {
            if (thumbnail != null) {
                if (!thumbnail.getOriginalFileName().startsWith("/")) {
                    SilverpeasFileProvider fileProvider = SilverpeasFileProvider.getInstance();
                    String path = ThumbnailController.getImageDirectory(fromPK.getInstanceId()) + File.separatorChar + thumbnail.getOriginalFileName();
                    String destinationPath = ThumbnailController.getImageDirectory(toPK.getInstanceId());
                    SilverpeasFile image = fileProvider.getSilverpeasFile(path);
                    image.moveInto(destinationPath);
                    if (thumbnail.getCropFileName() != null) {
                        path = ThumbnailController.getImageDirectory(fromPK.getInstanceId()) + File.separatorChar + thumbnail.getCropFileName();
                        image = fileProvider.getSilverpeasFile(path);
                        image.moveInto(destinationPath);
                    }
                }
                ThumbnailController.getThumbnailService().moveThumbnail(thumbnail, toPK.getInstanceId());
            }
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException("ThumbnailController.moveThumbnail()", 4, "thumbnail_CANT_MOVE_THUMBNAIL", e);
        }
    }

    protected static void createCropThumbnailFileOnServer(String pathOriginalFile, String pathCropdir, String pathCropFile, ThumbnailDetail thumbnail, int thumbnailWidth, int thumbnailHeight) {
        try {
            File cropFile;
            File dir = new File(pathCropdir);
            if (!dir.exists()) {
                FileFolderManager.createFolder(pathCropdir);
            }
            if (!(cropFile = new File(pathCropFile)).exists()) {
                cropFile.createNewFile();
            }
            File originalFile = new File(pathOriginalFile);
            BufferedImage bufferOriginal = ImageIO.read(originalFile);
            BufferedImage cropPicture = bufferOriginal.getSubimage(thumbnail.getXStart(), thumbnail.getYStart(), thumbnail.getXLength(), thumbnail.getYLength());
            BufferedImage cropPictureFinal = new BufferedImage(thumbnailWidth, thumbnailHeight, 1);
            Graphics2D g2 = cropPictureFinal.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(cropPicture, 0, 0, thumbnailWidth, thumbnailHeight, null);
            g2.dispose();
            String extension = FilenameUtils.getExtension((String)originalFile.getName());
            ImageIO.write((RenderedImage)cropPictureFinal, extension, cropFile);
        }
        catch (Exception e) {
            SilverTrace.warn("thumbnail", "ThumbnailController.createThumbnailFileOnServer()", "thumbnail_MSG_CREATE_CROP_FILE_KO", "originalFileName=" + thumbnail.getOriginalFileName() + " cropFileName = " + thumbnail.getCropFileName(), e);
        }
    }

    private static void deleteThumbnailFileOnServer(String componentId, String fileName) {
        String path = ThumbnailController.getImageDirectory(componentId) + fileName;
        try {
            SilverpeasFile image = SilverpeasFileProvider.getFile(path);
            image.delete();
        }
        catch (Exception e) {
            SilverTrace.warn("thumbnail", "ThumbnailController.deleteThumbnailFileOnServer(String componentId, String fileName)", "thumbnail_MSG_NOT_DELETE_FILE", "filePath=" + path, e);
        }
    }

    public static String getImage(String instanceId, int objectId, int objectType) {
        ThumbnailDetail thumbDetail = new ThumbnailDetail(instanceId, objectId, objectType);
        String[] imageProps = ThumbnailController.getImageAndMimeType(thumbDetail);
        return imageProps[0];
    }

    public static String getImageMimeType(String instanceId, int objectId, int objectType) {
        ThumbnailDetail thumbDetail = new ThumbnailDetail(instanceId, objectId, objectType);
        String[] imageProps = ThumbnailController.getImageAndMimeType(thumbDetail);
        return imageProps[1];
    }

    public static String[] getImageAndMimeType(ThumbnailDetail thumbDetail) {
        try {
            ThumbnailDetail thumbDetailComplete = ThumbnailController.getThumbnailService().getCompleteThumbnail(thumbDetail);
            if (thumbDetailComplete != null) {
                if (thumbDetailComplete.getCropFileName() != null) {
                    return new String[]{thumbDetailComplete.getCropFileName(), thumbDetailComplete.getMimeType()};
                }
                return new String[]{thumbDetailComplete.getOriginalFileName(), thumbDetailComplete.getMimeType()};
            }
            return new String[]{null, null};
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException("ThumbnailController.getCompleteThumbnail()", 4, "thumbnail_MSG_GET_IMAGE_KO", e);
        }
    }

    public static ThumbnailDetail cropThumbnail(ThumbnailDetail thumbnail, int thumbnailWidth, int thumbnailHeight) {
        try {
            ThumbnailDetail thumbDetailComplete = ThumbnailController.getThumbnailService().getCompleteThumbnail(thumbnail);
            if (thumbDetailComplete.getCropFileName() != null) {
                ThumbnailController.deleteThumbnailFileOnServer(thumbnail.getInstanceId(), thumbDetailComplete.getCropFileName());
            } else {
                String extension = FilenameUtils.getExtension((String)thumbDetailComplete.getOriginalFileName());
                String cropFileName = String.valueOf(new Date().getTime()) + '.' + extension;
                thumbDetailComplete.setCropFileName(cropFileName);
            }
            String pathCropdir = ThumbnailController.getImageDirectory(thumbnail.getInstanceId());
            String pathOriginalFile = pathCropdir + thumbDetailComplete.getOriginalFileName();
            String pathCropFile = pathCropdir + thumbDetailComplete.getCropFileName();
            ThumbnailController.createCropThumbnailFileOnServer(pathOriginalFile, pathCropdir, pathCropFile, thumbnail, thumbnailWidth, thumbnailHeight);
            thumbDetailComplete.setXStart(thumbnail.getXStart());
            thumbDetailComplete.setXLength(thumbnail.getXLength());
            thumbDetailComplete.setYStart(thumbnail.getYStart());
            thumbDetailComplete.setYLength(thumbnail.getYLength());
            ThumbnailController.getThumbnailService().updateThumbnail(thumbDetailComplete);
            return thumbDetailComplete;
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException("ThumbnailController.cropThumbnail()", 4, "thumbnail_MSG_GET_IMAGE_KO", e);
        }
    }

    private static void createCropFile(int thumbnailWidth, int thumbnailHeight, ThumbnailDetail thumbDetailComplete) throws IOException, ThumbnailException {
        String[] result;
        String pathOriginalFile = ThumbnailController.getImageDirectory(thumbDetailComplete.getInstanceId()) + thumbDetailComplete.getOriginalFileName();
        if (thumbnailWidth == -1 && thumbnailHeight != -1) {
            result = ImageUtil.getWidthAndHeightByHeight(new File(pathOriginalFile), thumbnailHeight);
            thumbnailWidth = Integer.valueOf(result[0]);
            thumbnailHeight = Integer.valueOf(result[1]);
        } else if (thumbnailHeight == -1 && thumbnailWidth != -1) {
            result = ImageUtil.getWidthAndHeightByWidth(new File(pathOriginalFile), thumbnailWidth);
            thumbnailWidth = Integer.valueOf(result[0]);
            thumbnailHeight = Integer.valueOf(result[1]);
        } else if (thumbnailHeight == -1) {
            result = ImageUtil.getWidthAndHeight(new File(pathOriginalFile));
            thumbnailWidth = Integer.valueOf(result[0]);
            thumbnailHeight = Integer.valueOf(result[1]);
        }
        String extension = FilenameUtils.getExtension((String)thumbDetailComplete.getOriginalFileName());
        String cropFileName = String.valueOf(new Date().getTime() + 2L) + '.' + extension;
        thumbDetailComplete.setCropFileName(cropFileName);
        ThumbnailController.cropFromPath(pathOriginalFile, thumbDetailComplete, thumbnailHeight, thumbnailWidth);
    }

    protected static void cropFromPath(String pathOriginalFile, ThumbnailDetail thumbDetailComplete, int thumbnailHeight, int thumbnailWidth) throws IOException, ThumbnailException {
        File originalFile = new File(pathOriginalFile);
        BufferedImage bufferOriginal = ImageIO.read(originalFile);
        if (bufferOriginal == null) {
            SilverTrace.error("thumbnail", "ThumbnailController.cropFromPath(int thumbnailWidth, int thumbnailHeight,ThumbnailDetail thumbDetailComplete)", "thumbnail.EX_MSG_NOT_AN_IMAGE", "pathOriginalFile=" + pathOriginalFile);
            throw new ThumbnailException("ThumbnailBmImpl.cropFromPath()", 4, "thumbnail.EX_MSG_NOT_AN_IMAGE");
        }
        thumbDetailComplete.setXStart(0);
        thumbDetailComplete.setYStart(0);
        thumbDetailComplete.setXLength(bufferOriginal.getWidth());
        thumbDetailComplete.setYLength(bufferOriginal.getHeight());
        String pathCropFile = ThumbnailController.getImageDirectory(thumbDetailComplete.getInstanceId()) + thumbDetailComplete.getCropFileName();
        ThumbnailController.createCropThumbnailFileOnServer(pathOriginalFile, ThumbnailController.getImageDirectory(thumbDetailComplete.getInstanceId()), pathCropFile, thumbDetailComplete, thumbnailWidth, thumbnailHeight);
        ThumbnailController.getThumbnailService().updateThumbnail(thumbDetailComplete);
    }

    protected static String getImageDirectory(String instanceId) {
        return FileRepositoryManager.getAbsolutePath(instanceId) + publicationSettings.getString("imagesSubDirectory") + File.separatorChar;
    }
}

