/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.thumbnail.service;

import com.silverpeas.annotation.Service;
import com.silverpeas.thumbnail.ThumbnailException;
import com.silverpeas.thumbnail.model.ThumbnailDAO;
import com.silverpeas.thumbnail.model.ThumbnailDetail;
import com.silverpeas.thumbnail.service.ThumbnailService;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.SQLException;

@Service
public class ThumbnailServiceImpl
implements ThumbnailService {
    protected ThumbnailServiceImpl() {
    }

    @Override
    public ThumbnailDetail createThumbnail(ThumbnailDetail thumbDetail) throws ThumbnailException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.THUMBNAIL_DATASOURCE);
            ThumbnailDetail thumbnailDetail = ThumbnailDAO.insertThumbnail(con, thumbDetail);
            return thumbnailDetail;
        }
        catch (SQLException se) {
            throw new ThumbnailException("ThumbnailBmImpl.createThumbnail()", 4, "thumbnail.EX_INSERT_ROW", se);
        }
        catch (UtilException e) {
            throw new ThumbnailException("ThumbnailBmImpl.createThumbnail()", 4, "thumbnail.EX_MSG_RECORD_NOT_INSERT", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public void updateThumbnail(ThumbnailDetail thumbDetail) throws ThumbnailException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.THUMBNAIL_DATASOURCE);
            ThumbnailDAO.updateThumbnail(con, thumbDetail);
        }
        catch (SQLException se) {
            throw new ThumbnailException("ThumbnailBmImpl.updateAttachment()", 4, "thumbnail.EX_MSG_RECORD_NOT_UPDATE", se);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public void deleteThumbnail(ThumbnailDetail thumbDetail) throws ThumbnailException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.THUMBNAIL_DATASOURCE);
            ThumbnailDAO.deleteThumbnail(con, thumbDetail.getObjectId(), thumbDetail.getObjectType(), thumbDetail.getInstanceId());
        }
        catch (SQLException se) {
            throw new ThumbnailException("ThumbnailBmImpl.deleteThumbnail()", 4, "thumbnail.EX_MSG_RECORD_NOT_DELETE", se);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public ThumbnailDetail getCompleteThumbnail(ThumbnailDetail thumbDetail) throws ThumbnailException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.THUMBNAIL_DATASOURCE);
            ThumbnailDetail thumbnailDetail = ThumbnailDAO.selectByKey(con, thumbDetail.getInstanceId(), thumbDetail.getObjectId(), thumbDetail.getObjectType());
            return thumbnailDetail;
        }
        catch (SQLException se) {
            throw new ThumbnailException("ThumbnailBmImpl.getCompleteThumbnail()", 4, "thumbnail.EX_MSG_NOT_FOUND", se);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public void deleteAllThumbnail(String componentId) throws ThumbnailException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.THUMBNAIL_DATASOURCE);
            ThumbnailDAO.deleteAllThumbnails(con, componentId);
        }
        catch (SQLException se) {
            throw new ThumbnailException("ThumbnailBmImpl.deleteAllThumbnail()", 4, "thumbnail_MSG_DELETE_ALL_FAILED", se);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public void moveThumbnail(ThumbnailDetail thumbDetail, String toInstanceId) throws ThumbnailException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.THUMBNAIL_DATASOURCE);
            ThumbnailDAO.moveThumbnail(con, thumbDetail, toInstanceId);
        }
        catch (SQLException se) {
            throw new ThumbnailException("ThumbnailBmImpl.moveThumbnail()", 4, "thumbnail.EX_MSG_CANT_MOVE_THUMBNAIL", se);
        }
        finally {
            DBUtil.close(con);
        }
    }
}

