/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutionAttempts {
    public static void retry(int maxAttempts, Job aJob) throws Exception {
        int attempts = 1;
        while (true) {
            try {
                aJob.execute();
            }
            catch (Exception ex) {
                Logger.getLogger(ExecutionAttempts.class.getName()).log(Level.WARNING, "Execution of job {0} failed. Try once more", aJob.getClass().getSimpleName());
                if (++attempts <= maxAttempts) continue;
                throw ex;
            }
            break;
        }
    }

    public static interface Job {
        public void execute() throws Exception;
    }
}

