/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailUtil {
    public static final String SMTP_SERVER = "SMTPServer";
    public static final String SMTP_AUTH = "SMTPAuthentication";
    public static final String SMTP_PORT = "SMTPPort";
    public static final String SMTP_LOGIN = "SMTPUser";
    public static final String SMTP_PASSWORD = "SMTPPwd";
    public static final String SMTP_DEBUG = "SMTPDebug";
    public static final String SMTP_SECURE = "SMTPSecure";
    private static final String mailhost;
    private static final boolean authenticated;
    private static final boolean secure;
    private static final boolean debug;
    private static final int port;
    private static final String login;
    private static final String password;
    private static final String notificationAddress;
    private static final String notificationPersonalName;
    private static final boolean forceReplyToSenderField;
    private static Iterable<String> domains;
    public static final ResourceLocator configuration;

    public static boolean isForceReplyToSenderField() {
        return forceReplyToSenderField;
    }

    static void reloadConfiguration(String domainsList) {
        if (StringUtil.isDefined(domainsList)) {
            String[] authorizedDomains = StringUtil.split((String)domainsList, (char)',');
            domains = new ArrayList<String>(authorizedDomains.length);
            for (String domain : authorizedDomains) {
                if (!StringUtil.isDefined(domain)) continue;
                ((List)domains).add(domain.trim());
            }
        } else {
            domains = Collections.singletonList("");
        }
    }

    public static synchronized boolean isDomainAuthorized(String email) {
        if (StringUtil.isDefined(email)) {
            String emailAddress = email.toLowerCase(I18NHelper.defaultLocale);
            for (String domain : domains) {
                if (!emailAddress.endsWith(domain.toLowerCase(I18NHelper.defaultLocale))) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized InternetAddress getAuthorizedEmailAddress(String pFrom, String personalName) throws AddressException, UnsupportedEncodingException {
        String personal;
        String senderAddress = MailUtil.getAuthorizedEmail(pFrom);
        InternetAddress address = new InternetAddress(senderAddress, true);
        String string = personal = senderAddress.equals(pFrom) ? personalName : notificationPersonalName;
        if (StringUtil.isDefined(personal)) {
            address.setPersonal(personal, "UTF-8");
        }
        return address;
    }

    public static synchronized String getAuthorizedEmail(String email) {
        if (MailUtil.isDomainAuthorized(email)) {
            return email;
        }
        return notificationAddress;
    }

    public static String getMailServer() {
        return mailhost;
    }

    public static boolean isAuthenticated() {
        return authenticated;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static String getLogin() {
        return login;
    }

    public static String getPassword() {
        return password;
    }

    public static int getPort() {
        return port;
    }

    public static boolean isSecure() {
        return secure;
    }

    private MailUtil() {
    }

    static {
        configuration = new ResourceLocator("org.silverpeas.notificationserver.channel.smtp.smtpSettings", "");
        mailhost = configuration.getString(SMTP_SERVER);
        authenticated = configuration.getBoolean(SMTP_AUTH, false);
        port = configuration.getInteger(SMTP_PORT, 25);
        login = configuration.getString(SMTP_LOGIN);
        password = configuration.getString(SMTP_PASSWORD);
        debug = configuration.getBoolean(SMTP_DEBUG, false);
        secure = configuration.getBoolean(SMTP_SECURE, false);
        notificationAddress = configuration.getString("NotificationAddress");
        notificationPersonalName = configuration.getString("NotificationPersonalName");
        forceReplyToSenderField = configuration.getBoolean("ForceReplyToSenderField", false);
        MailUtil.reloadConfiguration(configuration.getString("AuthorizedDomains", ""));
    }
}

