/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.i18n.I18NHelper;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    public static String newline = System.getProperty("line.separator");
    private static final char[] PUNCTUATION = new char[]{'&', '\"', '\'', '{', '(', '[', '-', '|', '`', '_', '\\', '^', '@', ')', ']', '=', '+', '}', '?', ',', '.', ';', '/', ':', '!', '\u00a7', '%', '*', '$', '\u00a3', '\u20ac', '\u00a9', '\u00b2', '\u00b0', '\u00a4'};
    private static final String PATTERN_START = "{";
    private static final String PATTERN_END = "}";
    private static final String TRUNCATED_TEXT_SUFFIX = "...";
    private static final String EMAIL_PATTERN = "^[A-Za-z0-9._%+\\-]+@[A-Za-z0-9.\\-]+\\.[A-Za-z]{2,4}$";
    private static final String HOUR_PATTERN = "^([0-1]?[0-9]|2[0-4]):([0-5][0-9])(:[0-5][0-9])?$";

    public static boolean isDefined(String parameter) {
        return parameter != null && !parameter.trim().isEmpty() && !"null".equalsIgnoreCase(parameter);
    }

    public static boolean isNotDefined(String parameter) {
        return !StringUtil.isDefined(parameter);
    }

    public static String defaultStringIfNotDefined(String string) {
        return StringUtil.defaultStringIfNotDefined(string, "");
    }

    public static String defaultStringIfNotDefined(String string, String defaultString) {
        return StringUtil.defaultString((String)(StringUtil.isDefined(string) ? string : null), (String)defaultString);
    }

    public static boolean isInteger(String id) {
        try {
            Integer.parseInt(id);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isLong(String id) {
        try {
            Long.parseLong(id);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static float convertFloat(String value) {
        String charge;
        if (StringUtil.isFloat(value)) {
            return Float.valueOf(value).floatValue();
        }
        if (value != null && StringUtil.isFloat(charge = value.replace(',', '.'))) {
            return Float.valueOf(charge).floatValue();
        }
        return 0.0f;
    }

    public static boolean isFloat(String id) {
        try {
            Float.parseFloat(id);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String escapeQuote(String text) {
        return text.replaceAll("'", " ");
    }

    public static String toAcceptableFilename(String name) {
        String fileName = name;
        fileName = fileName.replace('\\', '_');
        fileName = fileName.replace('/', '_');
        fileName = fileName.replace('$', '_');
        fileName = fileName.replace('%', '_');
        fileName = fileName.replace('?', '_');
        fileName = fileName.replace(':', '_');
        fileName = fileName.replace('*', '_');
        fileName = fileName.replace('\"', '_');
        fileName = fileName.replace('<', '_');
        fileName = fileName.replace('>', '_');
        fileName = fileName.replace('|', '_');
        return fileName;
    }

    public static String format(String label, Map<String, ?> values) {
        StringBuilder sb = new StringBuilder();
        int startIndex = label.indexOf(PATTERN_START);
        while (startIndex != -1) {
            int endIndex = label.indexOf(PATTERN_END, startIndex);
            if (endIndex != -1) {
                String patternKey = label.substring(startIndex + 1, endIndex);
                if (values.containsKey(patternKey)) {
                    Object value = values.get(patternKey);
                    sb.append(label.substring(0, startIndex)).append(value != null ? value.toString() : "");
                } else {
                    sb.append(label.substring(0, endIndex + 1));
                }
                label = label.substring(endIndex + 1);
                startIndex = label.indexOf(PATTERN_START);
                continue;
            }
            sb.append(label);
            label = "";
            startIndex = -1;
        }
        sb.append(label);
        return sb.toString();
    }

    public static String truncate(String text, int maxLength) {
        if (text == null || text.length() <= maxLength) {
            return text;
        }
        if (maxLength <= 3) {
            return TRUNCATED_TEXT_SUFFIX;
        }
        return text.substring(0, maxLength - 3) + TRUNCATED_TEXT_SUFFIX;
    }

    public static String regexReplace(String source, String regex, String replacement) {
        if (StringUtil.isNotDefined(source) || StringUtil.isNotDefined(regex)) {
            return source;
        }
        return source.replaceAll(regex, replacement);
    }

    public static boolean isValidEmailAddress(String aEmailAddress) {
        boolean result;
        if (aEmailAddress == null) {
            return false;
        }
        try {
            new InternetAddress(aEmailAddress);
            result = Pattern.matches(EMAIL_PATTERN, aEmailAddress);
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    public static boolean isValidHour(String time) {
        if (!StringUtil.isDefined(time)) {
            return false;
        }
        return Pattern.matches(HOUR_PATTERN, time);
    }

    public static String convertToEncoding(String toConvert, String encoding) {
        try {
            return new String(toConvert.getBytes(Charset.defaultCharset()), encoding);
        }
        catch (UnsupportedEncodingException ex) {
            return toConvert;
        }
    }

    public static boolean getBooleanValue(String expression) {
        return "true".equalsIgnoreCase(expression) || "yes".equalsIgnoreCase(expression) || "y".equalsIgnoreCase(expression) || "oui".equalsIgnoreCase(expression) || "1".equalsIgnoreCase(expression);
    }

    public static String detectEncoding(byte[] data, String declaredEncoding) {
        CharsetDetector detector = new CharsetDetector();
        if (!StringUtil.isDefined(declaredEncoding)) {
            detector.setDeclaredEncoding("ISO-8859-1");
        } else {
            detector.setDeclaredEncoding(declaredEncoding);
        }
        detector.setText(data);
        CharsetMatch detectedEnc = detector.detect();
        return detectedEnc.getName();
    }

    public static String detectStringEncoding(byte[] data, String declaredEncoding) throws UnsupportedEncodingException {
        String value;
        if (data != null && !StringUtil.checkEncoding(value = new String(data, declaredEncoding))) {
            Set<String> supportedEncodings = "UTF-8".equals(declaredEncoding) ? StringUtil.detectMaybeEncoding(data, "ISO-8859-1") : StringUtil.detectMaybeEncoding(data, "UTF-8");
            return StringUtil.reencode(data, supportedEncodings, declaredEncoding);
        }
        return declaredEncoding;
    }

    private static boolean checkEncoding(String value) {
        if (value != null) {
            char[] chars;
            for (char currentChar : chars = value.toCharArray()) {
                if (Character.isLetterOrDigit(currentChar) || Character.isWhitespace(currentChar) || ArrayUtil.contains((char[])PUNCTUATION, (char)currentChar)) continue;
                return false;
            }
        }
        return true;
    }

    private static String reencode(byte[] data, Set<String> encodings, String declaredEncoding) throws UnsupportedEncodingException {
        if (!encodings.isEmpty()) {
            String encoding = encodings.iterator().next();
            String value = new String(data, encoding);
            if (!StringUtil.checkEncoding(value)) {
                encodings.remove(encoding);
                return StringUtil.reencode(data, encodings, declaredEncoding);
            }
            return encoding;
        }
        return declaredEncoding;
    }

    public static Set<String> detectMaybeEncoding(byte[] data, String declaredEncoding) {
        CharsetDetector detector = new CharsetDetector();
        if (!StringUtil.isDefined(declaredEncoding)) {
            detector.setDeclaredEncoding("ISO-8859-1");
        } else {
            detector.setDeclaredEncoding(declaredEncoding);
        }
        detector.setText(data);
        CharsetMatch[] detectedEnc = detector.detectAll();
        LinkedHashSet<String> encodings = new LinkedHashSet<String>(detectedEnc.length);
        for (CharsetMatch detectedEncoding : detectedEnc) {
            encodings.add(detectedEncoding.getName());
        }
        return encodings;
    }

    public static boolean areStringEquals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public static float floatValue(String value) throws ParseException {
        return StringUtil.floatValue(value, I18NHelper.defaultLanguage);
    }

    public static float floatValue(String value, String language) throws ParseException {
        String lang = language;
        if (!StringUtil.isDefined(language)) {
            lang = I18NHelper.defaultLanguage;
        }
        NumberFormat numberFormat = NumberFormat.getInstance(new Locale(lang));
        return numberFormat.parse(value).floatValue();
    }

    public static String asBase64(byte[] binaryData) {
        return Base64.encodeBase64String((byte[])binaryData);
    }

    public static byte[] fromBase64(String base64Text) {
        return Base64.decodeBase64((String)base64Text);
    }

    public static String asHex(byte[] binaryData) {
        return Hex.encodeHexString((byte[])binaryData);
    }

    public static byte[] fromHex(String hexText) throws ParseException {
        try {
            return Hex.decodeHex((char[])hexText.toCharArray());
        }
        catch (DecoderException ex) {
            throw new ParseException(ex.getMessage(), -1);
        }
    }

    public static Iterable<String> splitString(String str) {
        return Arrays.asList(StringUtil.split((String)str));
    }

    public static Iterable<String> splitString(String str, char separatorChar) {
        return Arrays.asList(StringUtil.split((String)str, (char)separatorChar));
    }

    private StringUtil() {
    }
}

