/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.comparator;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.comparator.AbstractComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractComplexComparator<C>
extends AbstractComparator<C> {
    protected abstract ValueBuffer getValuesToCompare(C var1);

    @Override
    public int compare(C o1, C o2) {
        ValueBuffer baseValues = this.getValuesToCompare(o1);
        ValueBuffer comparedValues = this.getValuesToCompare(o2);
        int result = 0;
        Iterator<Object> it1 = baseValues.getValues().iterator();
        Iterator<Object> it2 = comparedValues.getValues().iterator();
        Iterator<Integer> itSens = baseValues.getSens().iterator();
        while (it1.hasNext()) {
            Object curO1 = it1.next();
            Object curO2 = it2.next();
            Integer sens = itSens.next();
            result = AbstractComplexComparator.compareInstance(curO1, curO2);
            if (result != 0) {
                return result * sens;
            }
            if (!AbstractComplexComparator.areInstancesComparable(curO1, curO2) || (result = AbstractComplexComparator.compare((Comparable)curO1, curO2)) == 0) continue;
            return result * sens;
        }
        return result;
    }

    public class StringWrapper
    implements Comparable<StringWrapper> {
        final String string;
        final boolean sort;
        final boolean emptyAtEnd;

        public StringWrapper(String string, boolean sort, boolean emptyAtEnd) {
            this.string = StringUtil.isNotDefined(string) ? null : string;
            this.sort = sort;
            this.emptyAtEnd = emptyAtEnd;
        }

        @Override
        public int compareTo(StringWrapper o) {
            int result = AbstractComparator.compareInstance(this.string, o.string);
            if (result != 0) {
                if (this.emptyAtEnd) {
                    return result * (this.sort ? -1 : 1);
                }
                return result * (this.sort ? 1 : -1);
            }
            if (AbstractComparator.areInstancesComparable(this.string, o.string)) {
                return this.string.compareTo(o.string);
            }
            return 0;
        }
    }

    public class ValueBuffer {
        private final List<Integer> sens = new ArrayList<Integer>();
        private final List<Object> values = new ArrayList<Object>();

        public ValueBuffer append(Object object, boolean isAscending) {
            this.values.add(object);
            if (isAscending) {
                this.sens.add(1);
            } else {
                this.sens.add(-1);
            }
            return this;
        }

        public ValueBuffer append(Object object) {
            return this.append(object, true);
        }

        public List<Integer> getSens() {
            return this.sens;
        }

        public List<Object> getValues() {
            return this.values;
        }
    }
}

