/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.csv;

import com.silverpeas.util.csv.Variant;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.exception.UtilTrappedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CSVReader {
    protected int m_nbCols = 0;
    protected String[] m_colNames;
    protected String[] m_colTypes;
    protected String[] m_colDefaultValues;
    protected String[] m_colMandatory;
    protected String m_separator;
    protected ResourceLocator m_utilMessages;
    protected int m_specificNbCols = 0;
    protected String[] m_specificColNames;
    protected int[] m_specificColMaxLengthes;
    protected String[] m_specificColTypes;
    protected String[] m_specificColMandatory;
    protected String[] m_specificParameterNames;
    private boolean columnNumberControlEnabled = true;
    private boolean extraColumnsControlEnabled = true;

    public boolean isExtraColumnsControlEnabled() {
        return this.extraColumnsControlEnabled;
    }

    public void setExtraColumnsControlEnabled(boolean extraColumnsControlEnabled) {
        this.extraColumnsControlEnabled = extraColumnsControlEnabled;
    }

    public boolean isColumnNumberControlEnabled() {
        return this.columnNumberControlEnabled;
    }

    public void setColumnNumberControlEnabled(boolean columnNumberControlEnabled) {
        this.columnNumberControlEnabled = columnNumberControlEnabled;
    }

    public CSVReader(String language) {
        this.m_utilMessages = new ResourceLocator("com.silverpeas.util.multilang.util", language);
    }

    public void initCSVFormat(String propertiesFile, String rootPropertyName, String separator) {
        ResourceLocator rs = new ResourceLocator(propertiesFile, "");
        this.m_colNames = rs.getStringArray(rootPropertyName, ".Name", -1);
        this.m_nbCols = this.m_colNames.length;
        this.m_colTypes = rs.getStringArray(rootPropertyName, ".Type", this.m_nbCols);
        this.m_colDefaultValues = rs.getStringArray(rootPropertyName, ".Default", this.m_nbCols);
        this.m_colMandatory = rs.getStringArray(rootPropertyName, ".Mandatory", this.m_nbCols);
        this.m_separator = separator;
    }

    public void initCSVFormat(String propertiesFile, String rootPropertyName, String separator, String specificPropertiesFile, String specificRootPropertyName) {
        this.initCSVFormat(propertiesFile, rootPropertyName, separator);
        ResourceLocator specificRs = new ResourceLocator(specificPropertiesFile, "");
        this.m_specificColNames = specificRs.getStringArray(specificRootPropertyName, ".Name", -1);
        this.m_specificNbCols = this.m_specificColNames.length;
        this.m_specificColTypes = specificRs.getStringArray(specificRootPropertyName, ".Type", this.m_specificNbCols);
        this.m_specificColMaxLengthes = new int[this.m_specificNbCols];
        for (int i = 0; i < this.m_specificNbCols; ++i) {
            if (!("STRING".equals(this.m_specificColTypes[i]) || "INT".equals(this.m_specificColTypes[i]) || "BOOLEAN".equals(this.m_specificColTypes[i]) || "FLOAT".equals(this.m_specificColTypes[i]) || "DATEFR".equals(this.m_specificColTypes[i]) || "DATEUS".equals(this.m_specificColTypes[i]) || "SARRAY".equals(this.m_specificColTypes[i]) || "LONG".equals(this.m_specificColTypes[i]))) {
                this.m_specificColTypes[i] = "STRING";
            }
            this.m_specificColMaxLengthes[i] = specificRs.getInteger(specificRootPropertyName + (i + 1) + ".MaxLength", 50);
        }
        this.m_specificColMandatory = specificRs.getStringArray(specificRootPropertyName, ".Mandatory", this.m_specificNbCols);
        this.m_specificParameterNames = this.m_specificColNames;
    }

    public Variant[][] parseStream(InputStream is) throws UtilTrappedException {
        ArrayList<Variant[]> valret = new ArrayList<Variant[]>();
        int lineNumber = 1;
        StringBuilder listErrors = new StringBuilder("");
        try {
            BufferedReader rb = new BufferedReader(new InputStreamReader(is));
            String theLine = rb.readLine();
            if (theLine != null && !this.isExtraColumnsControlEnabled()) {
                StringTokenizer st = new StringTokenizer(theLine, this.m_separator);
                this.setM_specificNbCols(st.countTokens() - this.m_nbCols);
            }
            while (theLine != null) {
                SilverTrace.info("util", "CSVReader.parseStream()", "root.MSG_PARAM_VALUE", "Line=" + lineNumber);
                if (theLine.trim().length() > 0) {
                    try {
                        valret.add(this.parseLine(theLine, lineNumber));
                    }
                    catch (UtilTrappedException u) {
                        listErrors.append(u.getExtraInfos()).append('\n');
                    }
                }
                ++lineNumber;
                theLine = rb.readLine();
            }
            if (listErrors.length() > 0) {
                throw new UtilTrappedException("CSVReader.parseStream", 4, "util.EX_PARSING_CSV_VALUE", listErrors.toString());
            }
            return (Variant[][])valret.toArray((T[])new Variant[0][0]);
        }
        catch (IOException e) {
            throw new UtilTrappedException("CSVReader.parseStream", 4, "util.EX_TRANSMITING_CSV", this.m_utilMessages.getString("util.ligne") + " = " + Integer.toString(lineNumber) + "\n" + listErrors.toString(), e);
        }
    }

    public Variant[] parseLine(String theLine, int lineNumber) throws UtilTrappedException {
        String theValue;
        int i;
        int nbColsTotal = this.m_nbCols + this.m_specificNbCols;
        Variant[] valret = new Variant[nbColsTotal];
        StringBuilder listErrors = new StringBuilder("");
        int start = 0;
        int end = theLine.indexOf(this.m_separator, start);
        for (i = 0; i < this.m_nbCols; ++i) {
            theValue = end == -1 ? theLine.substring(start).trim() : theLine.substring(start, end).trim();
            try {
                if (theValue == null || theValue.length() <= 0) {
                    if (Boolean.parseBoolean(this.m_colMandatory[i])) {
                        listErrors.append(this.m_utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
                        listErrors.append(this.m_utilMessages.getString("util.colonne")).append(" = ").append(Integer.toString(i + 1)).append(", ");
                        listErrors.append(this.m_utilMessages.getString("util.errorMandatory")).append(this.m_utilMessages.getString("util.valeur")).append(" = ").append(theValue).append(", ");
                        listErrors.append(this.m_utilMessages.getString("util.type")).append(" = ").append(this.m_colTypes[i]).append("<br/>");
                    } else {
                        theValue = this.m_colDefaultValues[i];
                    }
                }
                valret[i] = Variant.isArrayType(this.m_colTypes[i]) ? new Variant(this.parseArrayValue(theValue), this.m_colTypes[i]) : new Variant(theValue, this.m_colTypes[i]);
                SilverTrace.info("util", "CSVReader.parseLine()", "root.MSG_PARAM_VALUE", "Token=" + theValue);
            }
            catch (UtilException e) {
                listErrors.append(this.m_utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
                listErrors.append(this.m_utilMessages.getString("util.colonne")).append(" = ").append(Integer.toString(i + 1)).append(", ");
                listErrors.append(this.m_utilMessages.getString("util.errorType")).append(this.m_utilMessages.getString("util.valeur")).append(" = ").append(theValue).append(", ");
                listErrors.append(this.m_utilMessages.getString("util.type")).append(" = ").append(this.m_colTypes[i]).append("<br/>");
            }
            start = end + 1;
            if (start == 0) {
                start = -1;
            }
            end = i < this.m_nbCols - 1 && Variant.isArrayType(this.m_colTypes[i + 1]) ? -1 : theLine.indexOf(this.m_separator, start);
            if (!this.isColumnNumberControlEnabled() || i >= this.m_nbCols - 2 || end != -1) continue;
            listErrors.append(this.m_utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
            listErrors.append(Integer.toString(i + 2)).append(" ").append(this.m_utilMessages.getString("util.colonnesAttendues")).append(" ").append(Integer.toString(this.m_nbCols)).append(" ").append(this.m_utilMessages.getString("util.attendues")).append("<br/>");
        }
        int j = this.m_nbCols;
        for (i = 0; i < this.m_specificNbCols; ++i) {
            if (start == -1) {
                theValue = "";
                end = -2;
            } else {
                theValue = end == -1 ? theLine.substring(start).trim() : theLine.substring(start, end).trim();
            }
            if (this.isExtraColumnsControlEnabled()) {
                try {
                    valret[j] = new Variant(theValue, this.m_specificColTypes[i]);
                    SilverTrace.info("util", "CSVReader.parseLine()", "root.MSG_PARAM_VALUE", "Token=" + theValue);
                    if ((theValue == null || theValue.length() <= 0) && Boolean.parseBoolean(this.m_specificColMandatory[i])) {
                        listErrors.append(this.m_utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
                        listErrors.append(this.m_utilMessages.getString("util.colonne")).append(" = ").append(Integer.toString(i + 1)).append(", ");
                        listErrors.append(this.m_utilMessages.getString("util.errorMandatory")).append(this.m_utilMessages.getString("util.valeur")).append(" = ").append(theValue).append(", ");
                        listErrors.append(this.m_utilMessages.getString("util.type")).append(" = ").append(this.m_colTypes[i]).append("<br/>");
                    }
                }
                catch (UtilException e) {
                    listErrors.append(this.m_utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
                    listErrors.append(this.m_utilMessages.getString("util.colonne")).append(" = ").append(Integer.toString(j + 1)).append(", ");
                    listErrors.append(this.m_utilMessages.getString("util.errorType")).append(this.m_utilMessages.getString("util.valeur")).append(" = ").append(theValue).append(", ");
                    listErrors.append(this.m_utilMessages.getString("util.type")).append(" = ").append(this.m_specificColTypes[i]).append("<br/>");
                }
            } else {
                try {
                    valret[j] = new Variant(theValue, "STRING");
                }
                catch (UtilException e) {
                    SilverTrace.info("util", "CSVReader.parseLine()", "root.MSG_PARAM_VALUE", "Token=" + theValue);
                }
            }
            start = end + 1;
            if (start == 0) {
                start = -1;
            }
            end = this.isExtraColumnsControlEnabled() && i < this.m_specificNbCols - 1 && Variant.isArrayType(this.m_specificColTypes[i + 1]) ? -1 : theLine.indexOf(this.m_separator, start);
            if (this.isColumnNumberControlEnabled() && i < this.m_specificNbCols - 2 && end == -1) {
                listErrors.append(this.m_utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
                listErrors.append(Integer.toString(i + 2 + this.m_nbCols)).append(" ").append(this.m_utilMessages.getString("util.colonnesAttendues")).append(" ").append(Integer.toString(nbColsTotal)).append(" ").append(this.m_utilMessages.getString("util.attendues")).append("<br/>");
            }
            ++j;
        }
        int nbColonnes = nbColsTotal;
        while (start > -1) {
            ++nbColonnes;
            start = end + 1;
            if (start == 0) {
                start = -1;
            }
            end = theLine.indexOf(this.m_separator, start);
        }
        if (this.isColumnNumberControlEnabled() && nbColonnes > nbColsTotal) {
            listErrors.append(this.m_utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
            listErrors.append(nbColonnes).append(" ").append(this.m_utilMessages.getString("util.colonnesAttendues")).append(" ").append(Integer.toString(nbColsTotal)).append(" ").append(this.m_utilMessages.getString("util.attendues")).append("<br/>");
        }
        if (listErrors.length() > 0) {
            throw new UtilTrappedException("CSVReader.parseLine", 4, "util.EX_PARSING_CSV_VALUE", listErrors.toString());
        }
        return valret;
    }

    protected String[] parseArrayValue(String arrayValue) {
        ArrayList<String> ar = new ArrayList<String>();
        boolean haveToContinue = true;
        int start = 0;
        while (haveToContinue) {
            String theValue;
            int end = arrayValue.indexOf(this.m_separator, start);
            if (end == -1) {
                theValue = arrayValue.substring(start).trim();
                haveToContinue = false;
            } else {
                theValue = arrayValue.substring(start, end).trim();
            }
            if (theValue == null || theValue.length() <= 0) {
                theValue = "";
            }
            ar.add(theValue);
            start = end + 1;
        }
        return ar.toArray(new String[ar.size()]);
    }

    public int getM_nbCols() {
        return this.m_nbCols;
    }

    public String getM_separator() {
        return this.m_separator;
    }

    public String[] getM_colDefaultValues() {
        return this.m_colDefaultValues;
    }

    public String[] getM_colMandatory() {
        return this.m_colMandatory;
    }

    public String getM_colDefaultValues(int i) {
        return this.m_colDefaultValues[i];
    }

    public String[] getM_colTypes() {
        return this.m_colTypes;
    }

    public String getM_colTypes(int i) {
        return this.m_colTypes[i];
    }

    public int getM_specificNbCols() {
        return this.m_specificNbCols;
    }

    public void setM_specificNbCols(int cols) {
        this.m_specificNbCols = cols;
    }

    public String[] getM_specificColNames() {
        return this.m_specificColNames;
    }

    public String getM_specificColName(int i) {
        return this.m_specificColNames[i];
    }

    public String[] getM_specificColTypes() {
        return this.m_specificColTypes;
    }

    public String getM_specificColType(int i) {
        return this.m_specificColTypes[i];
    }

    public String[] getM_specificParameterNames() {
        return this.m_specificParameterNames;
    }

    public String getM_specificParameterName(int i) {
        return this.m_specificParameterNames[i];
    }

    public int[] getM_specificColMaxLengthes() {
        return this.m_specificColMaxLengthes;
    }

    public int getM_specificColMaxLength(int i) {
        return this.m_specificColMaxLengthes[i];
    }
}

