/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.i18n;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NBean;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.util.i18n.Translation;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractI18NBean<T extends Translation>
implements Serializable,
I18NBean<T> {
    private static final long serialVersionUID = 756146888448232764L;
    private String name = "";
    private String description = "";
    private String language = null;
    private String translationId = null;
    private Map<String, T> translations = new HashMap<String, T>(3);
    private boolean removeTranslation = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public String getName(String language) {
        if (!I18NHelper.isI18nContentActivated) {
            return this.name;
        }
        T translation = this.selectTranslation(language);
        if (translation != null) {
            return ((Translation)translation).getName();
        }
        return this.name;
    }

    public String getDescription(String language) {
        if (!I18NHelper.isI18nContentActivated) {
            return this.description;
        }
        T translation = this.selectTranslation(language);
        if (translation != null) {
            return ((Translation)translation).getDescription();
        }
        return this.description;
    }

    private T selectTranslation(String language) {
        Translation translation = (Translation)this.getTranslations().get(StringUtil.isDefined(language) ? language : I18NHelper.defaultLanguage);
        if (translation == null) {
            translation = this.getNextTranslation();
        }
        return (T)translation;
    }

    public String getLanguage() {
        if (I18NHelper.isI18nContentActivated && StringUtil.isNotDefined(this.language)) {
            return I18NHelper.defaultLanguage;
        }
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isRemoveTranslation() {
        return this.removeTranslation;
    }

    @Override
    public void setRemoveTranslation(boolean removeTranslation) {
        this.removeTranslation = removeTranslation;
    }

    public String getTranslationId() {
        return this.translationId;
    }

    @Override
    public void setTranslationId(String translationId) {
        this.translationId = translationId;
    }

    public Iterator<String> getLanguages() {
        return this.translations.keySet().iterator();
    }

    @Override
    public Map<String, T> getTranslations() {
        return this.translations;
    }

    public Map<String, T> getClonedTranslations() {
        HashMap<String, Translation> clonedTranslations = new HashMap<String, Translation>(3);
        for (Map.Entry<String, T> entry : this.translations.entrySet()) {
            clonedTranslations.put(entry.getKey(), ((Translation)entry.getValue()).clone());
        }
        return clonedTranslations;
    }

    public void setTranslations(Map<String, T> translations) {
        this.translations = translations;
    }

    public void setTranslations(Collection<T> translations) {
        if (translations != null && !translations.isEmpty()) {
            for (Translation translation : translations) {
                this.addTranslation(translation);
            }
        }
    }

    public void setTranslations(List<T> translations) {
        if (translations != null && !translations.isEmpty()) {
            for (Translation translation : translations) {
                this.addTranslation(translation);
            }
        }
    }

    @Override
    public T getTranslation(String language) {
        return (T)((Translation)this.translations.get(language));
    }

    public void addTranslation(T translation) {
        String language = ((Translation)translation).getLanguage();
        if (!StringUtil.isDefined(language)) {
            language = I18NHelper.defaultLanguage;
            ((Translation)translation).setLanguage(language);
        }
        this.translations.put(language, translation);
    }

    @Override
    public T getNextTranslation() {
        Iterator<String> languages = I18NHelper.getLanguages();
        Translation translation = null;
        while (translation == null && languages.hasNext()) {
            translation = (Translation)this.getTranslations().get(languages.next());
        }
        return (T)translation;
    }

    public String getLanguageToDisplay(String language) {
        String languageToDisplay = language;
        T translation = this.getTranslation(language);
        if (translation == null && (translation = this.getNextTranslation()) != null) {
            languageToDisplay = ((Translation)translation).getLanguage();
        }
        return languageToDisplay;
    }
}

