/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.i18n;

import com.silverpeas.ui.DisplayI18NHelper;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NBean;
import com.silverpeas.util.i18n.I18NLanguage;
import com.silverpeas.util.i18n.Translation;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.util.ResourcesWrapper;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;

public class I18NHelper {
    private static final Map<String, List<I18NLanguage>> allContentLanguages = new LinkedHashMap<String, List<I18NLanguage>>();
    private static final Map<String, List<I18NLanguage>> fallbackContentLanguages = new LinkedHashMap<String, List<I18NLanguage>>();
    private static int nbContentLanguages = 0;
    public static boolean isI18nContentActivated = false;
    public static String defaultLanguage = null;
    public static Locale defaultLocale = Locale.getDefault();
    private static final List<String> allContentLanguageCodes = new ArrayList<String>();
    public static final String HTMLSelectObjectName = "I18NLanguage";
    public static final String HTMLHiddenRemovedTranslationMode = "TranslationRemoveIt";

    public static String getLanguageLabel(String code, String userLanguage) {
        List<I18NLanguage> labels = I18NHelper.getAllUserTranslationsOfContentLanguages(userLanguage);
        for (I18NLanguage language : labels) {
            if (!language.getCode().equalsIgnoreCase(code)) continue;
            return language.getLabel();
        }
        return "";
    }

    public static List<I18NLanguage> getAllUserTranslationsOfContentLanguages(String userLanguage) {
        List<I18NLanguage> allContentLanguageUserTranslations = allContentLanguages.get(userLanguage);
        if (allContentLanguageUserTranslations == null) {
            allContentLanguageUserTranslations = fallbackContentLanguages.get(userLanguage);
        }
        return allContentLanguageUserTranslations;
    }

    public static Iterator<String> getLanguages() {
        return allContentLanguages.keySet().iterator();
    }

    public static Set<String> getAllSupportedLanguages() {
        return allContentLanguages.keySet();
    }

    public static int getNumberOfLanguages() {
        return allContentLanguages.size();
    }

    public static boolean isDefaultLanguage(String language) {
        if (StringUtil.isDefined(language)) {
            return defaultLanguage.equalsIgnoreCase(language);
        }
        return true;
    }

    public static String checkLanguage(String language) {
        String lang = language;
        if (!StringUtil.isDefined(language) || !allContentLanguageCodes.contains(language)) {
            lang = defaultLanguage;
        }
        return lang;
    }

    public static String getHTMLLinks(String url, String currentLanguage) {
        if (!isI18nContentActivated) {
            return "";
        }
        String baseUrl = url;
        baseUrl = url.contains("?") ? baseUrl + "&SwitchLanguage=" : baseUrl + "?SwitchLanguage=";
        StringBuilder links = new StringBuilder(512);
        boolean first = true;
        for (String code : allContentLanguageCodes) {
            String className = "";
            String link = baseUrl + code;
            if (!first) {
                links.append("&nbsp;");
            }
            if (code.equals(currentLanguage)) {
                className = "ArrayNavigationOn";
            }
            links.append("<a href=\"").append(link).append("\" class=\"").append(className).append("\" id=\"translation_").append(code).append("\">").append(code.toUpperCase(defaultLocale)).append("</a>");
            first = false;
        }
        return links.toString();
    }

    public static String getHTMLLinks(List<String> languages, String currentLanguage) {
        if (!isI18nContentActivated || languages == null) {
            return "";
        }
        StringBuilder links = new StringBuilder(512);
        String link = "";
        String begin = "";
        String end = "";
        boolean first = true;
        for (String code : allContentLanguageCodes) {
            String className = "";
            if (!languages.contains(code)) continue;
            link = "javaScript:showTranslation('" + code + "');";
            if (!first) {
                links.append("&nbsp;");
            }
            if (code.equals(currentLanguage) || languages.size() == 1) {
                className = "ArrayNavigationOn";
            }
            links.append("<a href=\"").append(link).append("\" class=\"").append(className).append("\" id=\"translation_").append(code).append("\">").append(code.toUpperCase(defaultLocale)).append("</a>");
            first = false;
        }
        return links.toString();
    }

    public static String getHTMLLinks(I18NBean bean, String currentLanguage) {
        Object translation;
        String lang = currentLanguage;
        if (!isI18nContentActivated || bean == null) {
            return "";
        }
        if (bean.getTranslation(lang) == null && (translation = bean.getNextTranslation()) != null) {
            lang = ((Translation)translation).getLanguage();
        }
        ArrayList<String> languages = new ArrayList<String>(bean.getTranslations().keySet());
        return I18NHelper.getHTMLLinks(languages, lang);
    }

    public static String getFormLine(ResourcesWrapper resources) {
        return I18NHelper.getFormLine(resources, null, null);
    }

    public static String getFormLine(ResourcesWrapper resources, I18NBean bean, String translation) {
        if (nbContentLanguages == 1) {
            return "";
        }
        StringBuilder tr = new StringBuilder(50);
        tr.append("<tr>\n");
        tr.append("<td class=\"txtlibform\">").append(resources.getString("GML.language")).append(" :</td>\n");
        tr.append("<td>").append(I18NHelper.getHTMLSelectObject(resources.getLanguage(), bean, translation)).append("</td>");
        tr.append("</tr>\n");
        return tr.toString();
    }

    public static String getHTMLSelectObject(String userLanguage, I18NBean bean, String selectedTranslation) {
        List<I18NLanguage> languages = I18NHelper.getAllUserTranslationsOfContentLanguages(userLanguage);
        ArrayList<I18NLanguage> result = new ArrayList<I18NLanguage>();
        for (I18NLanguage lang : languages) {
            Object translation;
            I18NLanguage newLang = new I18NLanguage(lang.getCode(), lang.getLabel());
            if (bean != null && (translation = bean.getTranslation(newLang.getCode())) != null) {
                newLang.setTranslationId(((Translation)translation).getId());
            }
            result.add(newLang);
        }
        return I18NHelper.getHTMLSelectObject(result, bean, selectedTranslation, userLanguage);
    }

    private static String getHTMLSelectObject(List<I18NLanguage> toDisplay, I18NBean bean, String selectedTranslation, String userLanguage) {
        String list = "";
        String currentTranslation = selectedTranslation;
        String onChangeJavascript = "";
        if (bean != null) {
            Object translation;
            onChangeJavascript = "onChange= \"javaScript:showTranslation(this.value.substring(0,2));\"";
            if (bean.getTranslation(currentTranslation) == null && (translation = bean.getNextTranslation()) != null) {
                currentTranslation = ((Translation)translation).getLanguage();
            }
        }
        list = list + "<SELECT name=\"I18NLanguage\" " + onChangeJavascript + ">\n";
        for (I18NLanguage language : toDisplay) {
            String selected = "";
            if (language.getCode().equals(currentTranslation)) {
                selected = "selected";
            }
            list = list + "<option value=\"" + language.getCode() + '_' + language.getTranslationId() + "\" " + selected + '>' + language.getLabel() + "</option>\n";
        }
        list = list + "</SELECT>";
        if (bean != null) {
            String path = URLManager.getApplicationURL();
            String text = GeneralPropertiesManager.getGeneralMultilang(userLanguage).getString("GML.translationRemove");
            list = list + "&nbsp;<span id=\"delTranslationLink\">";
            if (bean.getTranslations().size() >= 2) {
                list = list + "<a href=\"javaScript:document.getElementById('TranslationRemoveIt').value='true';removeTranslation();\"><img src=\"" + path + "/util/icons/delete.gif\" border=\"0\" valign=\"absmiddle\" title=\"" + text + "\" alt=\"" + text + "\"></a>";
            }
            list = list + "</span>";
            list = list + "<input type=\"hidden\" id=\"TranslationRemoveIt\" name=\"TranslationRemoveIt\" value=\"false\">\n";
        }
        return list;
    }

    public static String updateHTMLLinks(I18NBean bean) {
        String javaScript = "";
        Set<String> codes = bean.getTranslations().keySet();
        for (String lang : codes) {
            javaScript = javaScript + "document.getElementById(\"translation_" + lang + "\").className = \"\";\n";
            javaScript = javaScript + "if (lang == '" + lang + "')\n";
            javaScript = javaScript + "{\n";
            javaScript = javaScript + "document.getElementById(\"translation_" + lang + "\").className = \"ArrayNavigationOn\";\n";
            javaScript = javaScript + "}\n";
        }
        return javaScript;
    }

    public static String[] getLanguageAndTranslationId(HttpServletRequest request) {
        String param = request.getParameter(HTMLSelectObjectName);
        return I18NHelper.getLanguageAndTranslationId(param);
    }

    private static String[] getLanguageAndTranslationId(String param) {
        if (StringUtil.isDefined(param)) {
            StringTokenizer tokenizer = new StringTokenizer(param, "_");
            String language = tokenizer.nextToken();
            String translationId = tokenizer.nextToken();
            String[] result = new String[]{language, translationId};
            return result;
        }
        return null;
    }

    public static String getSelectedContentLanguage(HttpServletRequest request) {
        String[] param = I18NHelper.getLanguageAndTranslationId(request);
        if (param != null) {
            return param[0];
        }
        return null;
    }

    public static boolean isI18nContentEnabled() {
        return isI18nContentActivated;
    }

    public static void setI18NInfo(I18NBean bean, HttpServletRequest request) {
        String languageAndTranslationId = request.getParameter(HTMLSelectObjectName);
        String removeTranslation = request.getParameter(HTMLHiddenRemovedTranslationMode);
        I18NHelper.setI18NInfo(bean, languageAndTranslationId, removeTranslation);
    }

    public static void setI18NInfo(I18NBean bean, List<FileItem> parameters) {
        String languageAndTranslationId = I18NHelper.getParameterValue(parameters, HTMLSelectObjectName);
        String removeTranslation = I18NHelper.getParameterValue(parameters, HTMLHiddenRemovedTranslationMode);
        I18NHelper.setI18NInfo(bean, languageAndTranslationId, removeTranslation);
    }

    private static void setI18NInfo(I18NBean bean, String param, String removeParam) {
        String[] languageAndTranslationId = I18NHelper.getLanguageAndTranslationId(param);
        if (languageAndTranslationId != null) {
            String language = languageAndTranslationId[0];
            String translationId = languageAndTranslationId[1];
            bean.setLanguage(language);
            bean.setTranslationId(translationId);
            String removeTranslation = removeParam;
            bean.setRemoveTranslation("true".equalsIgnoreCase(removeTranslation));
        }
    }

    private static String getParameterValue(List<FileItem> items, String parameterName) {
        for (FileItem item : items) {
            if (!item.isFormField() || !parameterName.equals(item.getFieldName())) continue;
            return item.getString();
        }
        return null;
    }

    static {
        ResourceLocator rs = new ResourceLocator("org.silverpeas.util.i18n", "");
        String rsLanguages = rs.getString("languages");
        StringTokenizer tokenizer = new StringTokenizer(rsLanguages, ",");
        while (tokenizer.hasMoreTokens()) {
            String contentLanguageCode = tokenizer.nextToken();
            allContentLanguageCodes.add(contentLanguageCode);
            ++nbContentLanguages;
            if (defaultLanguage == null) {
                defaultLanguage = contentLanguageCode;
                defaultLocale = new Locale(contentLanguageCode);
            }
            ResourceLocator rsLanguage = new ResourceLocator("org.silverpeas.util.multilang.i18n", contentLanguageCode);
            StringTokenizer tokenizer2 = new StringTokenizer(rsLanguages, ",");
            ArrayList<I18NLanguage> contentLanguageLabels = new ArrayList<I18NLanguage>();
            while (tokenizer2.hasMoreTokens()) {
                String language2 = tokenizer2.nextToken();
                I18NLanguage i18nLanguage = new I18NLanguage(language2, rsLanguage.getString("language_" + language2));
                contentLanguageLabels.add(i18nLanguage);
            }
            allContentLanguages.put(contentLanguageCode, contentLanguageLabels);
        }
        isI18nContentActivated = nbContentLanguages > 1;
        ArrayList<String> fallbackLanguageCodes = new ArrayList<String>(DisplayI18NHelper.getLanguages());
        fallbackLanguageCodes.removeAll(allContentLanguageCodes);
        for (String fallbackLanguageCode : fallbackLanguageCodes) {
            ResourceLocator rsLanguage = new ResourceLocator("org.silverpeas.util.multilang.i18n", fallbackLanguageCode);
            ArrayList<I18NLanguage> fallbackLanguageLabels = new ArrayList<I18NLanguage>();
            for (String contentLanguageCode : allContentLanguageCodes) {
                I18NLanguage i18nLanguage = new I18NLanguage(contentLanguageCode, rsLanguage.getString("language_" + contentLanguageCode));
                fallbackLanguageLabels.add(i18nLanguage);
            }
            fallbackContentLanguages.put(fallbackLanguageCode, fallbackLanguageLabels);
        }
    }
}

