/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.security;

import java.util.concurrent.Semaphore;
import org.silverpeas.util.crypto.CryptoException;

class ConcurrentEncryptionTaskExecutor {
    private static final int TOKEN_COUNT = Integer.MAX_VALUE;
    private static final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE);

    ConcurrentEncryptionTaskExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(ConcurrentEncryptionTask task) throws CryptoException {
        int token = task.isPrivileged() ? Integer.MAX_VALUE : 1;
        try {
            ConcurrentEncryptionTaskExecutor.acquireToken(token);
            Object t = task.execute();
            return t;
        }
        finally {
            ConcurrentEncryptionTaskExecutor.releaseToken(token);
        }
    }

    private static synchronized void acquireToken(int token) {
        if (semaphore.availablePermits() == 0) {
            throw new IllegalStateException("The encryption is being updated: the content encryption and decryption service is blocked");
        }
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static synchronized void releaseToken(int token) {
        semaphore.release();
    }

    public static interface ConcurrentEncryptionTask {
        public boolean isPrivileged();

        public <T> T execute() throws CryptoException;
    }
}

