/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.security;

import com.silverpeas.util.security.ConcurrentEncryptionTaskExecutor;
import com.silverpeas.util.security.DefaultContentEncryptionService;
import com.silverpeas.util.security.EncryptionContentIterator;
import java.util.Map;
import org.silverpeas.util.crypto.Cipher;
import org.silverpeas.util.crypto.CipherKey;
import org.silverpeas.util.crypto.CryptoException;

class CryptographicTask
implements ConcurrentEncryptionTaskExecutor.ConcurrentEncryptionTask {
    private final Type task;
    private EncryptionContentIterator[] iterators;
    private boolean privileged = false;

    public static CryptographicTask encryptionOf(EncryptionContentIterator ... contents) {
        return new CryptographicTask(Type.ENCRYPTION, contents);
    }

    public static CryptographicTask decryptionOf(EncryptionContentIterator ... contents) {
        return new CryptographicTask(Type.DECRYPTION, contents);
    }

    public static CryptographicTask renewEncryptionOf(EncryptionContentIterator ... contents) {
        return new CryptographicTask(Type.RENEW, contents);
    }

    public CryptographicTask inPrivilegedMode() {
        this.privileged = true;
        return this;
    }

    @Override
    public boolean isPrivileged() {
        return this.privileged;
    }

    public Void execute() throws CryptoException {
        Cipher cipher = DefaultContentEncryptionService.getCipherForContentEncryption();
        CipherKey actualKey = DefaultContentEncryptionService.getActualCipherKey();
        CipherKey previousKey = this.task == Type.RENEW ? DefaultContentEncryptionService.getPreviousCipherKey() : null;
        for (EncryptionContentIterator encryptionContentIterator : this.iterators) {
            this.process(encryptionContentIterator, cipher, actualKey, previousKey);
        }
        return null;
    }

    private void process(EncryptionContentIterator theContents, Cipher cipher, CipherKey actualKey, CipherKey previousKey) {
        theContents.init();
        Map<String, String> content = null;
        try {
            while (theContents.hasNext()) {
                content = theContents.next();
                switch (this.task) {
                    case ENCRYPTION: {
                        content = DefaultContentEncryptionService.encryptContent(content, cipher, actualKey);
                        break;
                    }
                    case DECRYPTION: {
                        content = DefaultContentEncryptionService.decryptContent(content, cipher, actualKey);
                        break;
                    }
                    case RENEW: {
                        content = DefaultContentEncryptionService.decryptContent(content, cipher, previousKey);
                        content = DefaultContentEncryptionService.encryptContent(content, cipher, actualKey);
                    }
                }
                theContents.update(content);
            }
        }
        catch (Throwable ex) {
            theContents.onError(content, new CryptoException(ex.getMessage(), ex));
        }
    }

    CryptographicTask(Type taskType, EncryptionContentIterator ... iterators) {
        this.task = taskType;
        this.iterators = iterators;
    }

    private static enum Type {
        ENCRYPTION,
        DECRYPTION,
        RENEW;

    }
}

