/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SilverpeasX509TrustManager
implements X509TrustManager {
    final Logger logger = LoggerFactory.getLogger(SilverpeasX509TrustManager.class);
    private X509TrustManager defaultTrustManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SilverpeasX509TrustManager(String trustStoreFile, char[] password) {
        FileInputStream fis = null;
        try {
            TrustManager[] tms;
            KeyStore trustore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(trustStoreFile);
            trustore.load(fis, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            tmf.init(trustore);
            for (TrustManager trustManager : tms = tmf.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                this.defaultTrustManager = (X509TrustManager)trustManager;
            }
        }
        catch (IOException ioex) {
            this.logger.error("Couldn't load trustore " + trustStoreFile, (Throwable)ioex);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
            return;
            catch (GeneralSecurityException secEx) {
                this.logger.error("Couldn't create trustore " + trustStoreFile, (Throwable)secEx);
                IOUtils.closeQuietly((InputStream)fis);
                return;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return;
        IOUtils.closeQuietly((InputStream)fis);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(xcs, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
        this.defaultTrustManager.checkServerTrusted(xcs, string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }
}

