/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.wysiwyg.dynamicvalue.pool;

import com.silverpeas.wysiwyg.dynamicvalue.pool.ConnectionPool;
import com.silverpeas.wysiwyg.dynamicvalue.pool.ConnectionPoolInformation;
import com.silverpeas.wysiwyg.dynamicvalue.pool.ConnectionPoolWithJDBC;
import com.silverpeas.wysiwyg.dynamicvalue.pool.TechnicalException;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionPoolWithJNDI
implements ConnectionPool {
    private static ConnectionPoolInformation poolInfo = null;

    @Override
    public Connection getConnection() throws SQLException {
        SilverTrace.debug("wysiwyg", ConnectionPoolWithJNDI.class.toString(), " Datasource initialization : starting ...");
        if (poolInfo == null) {
            SilverTrace.error("wysiwig", ConnectionPoolWithJNDI.class.toString(), "wysiwig.DRIVER_MISSING");
            throw new TechnicalException(ConnectionPoolWithJNDI.class.toString() + " : An error occurred  during the connection initialization. The Pool information must be set");
        }
        Connection conn = null;
        try {
            conn = DBUtil.makeConnection(poolInfo.getJndiName());
        }
        catch (UtilException e) {
            SilverTrace.error("wysiwig", ConnectionPoolWithJNDI.class.toString(), "root.EX_CANT_INSTANCIATE_DB_DRIVER");
            throw new TechnicalException(ConnectionPoolWithJNDI.class.toString() + " : An error occurred  during the connection initialization.", e);
        }
        SilverTrace.debug("wysiwyg", ConnectionPoolWithJDBC.class.toString(), " Datasource initialization : ending ...");
        return conn;
    }

    @Override
    public ConnectionPoolInformation getPoolInformation() {
        return poolInfo;
    }

    @Override
    public void setPoolInformation(ConnectionPoolInformation poolInfo) {
        ConnectionPoolWithJNDI.poolInfo = poolInfo;
    }
}

