/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.containerManager;

import com.stratelia.silverpeas.containerManager.ContainerInterface;
import com.stratelia.silverpeas.containerManager.ContainerManagerException;
import com.stratelia.silverpeas.containerManager.ContainerPeas;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.JoinStatement;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class ContainerManager
implements Serializable {
    private static final long serialVersionUID = 3059920239753917851L;
    private static boolean s_bDescriptorsRead = false;
    private static List<ContainerPeas> s_acContainerPeas = null;
    private static Hashtable<String, String> assoComponentIdInstanceId = null;
    private static String m_dbName = JNDINames.CONTAINERMANAGER_DATASOURCE;
    private static String m_sInstanceTable = "SB_ContainerManager_Instance";
    String m_sLinksTable = "SB_ContainerManager_Links";

    public ContainerManager() {
        if (!s_bDescriptorsRead) {
            ContainerPeas containerPDC = new ContainerPeas("containerPDC");
            s_acContainerPeas = new ArrayList<ContainerPeas>();
            s_acContainerPeas.add(containerPDC);
            s_bDescriptorsRead = true;
        }
    }

    public int registerNewContainerInstance(Connection connection, String sComponentId, String sContainerType, String sContentType) throws ContainerManagerException {
        int n;
        boolean bCloseConnection = false;
        this.checkParameters(sComponentId, sContainerType, sContentType);
        PreparedStatement prepStmt = null;
        try {
            if (connection == null) {
                connection = DBUtil.makeConnection(m_dbName);
                bCloseConnection = true;
            }
            int newInstanceId = DBUtil.getNextId(m_sInstanceTable, "instanceId");
            String sSQLStatement = "INSERT INTO " + m_sInstanceTable + "(instanceId, componentId, containerType, contentType) ";
            sSQLStatement = sSQLStatement + "VALUES (" + newInstanceId + ",'" + sComponentId + "','" + sContainerType + "','" + sContentType + "')";
            SilverTrace.info("containerManager", "ContainerManager.registerNewContainerInstance", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            prepStmt.executeUpdate();
            this.addAsso(sComponentId, newInstanceId);
            n = newInstanceId;
        }
        catch (Exception e) {
            try {
                throw new ContainerManagerException("ContainerManager.registerNewContainerInstance", 4, "containerManager.EX_CANT_REGISTER_CONTAINER_INSTANCE", "componentId: " + sComponentId + "    sContainerType: " + sContainerType, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                if (bCloseConnection) {
                    this.closeConnection(connection);
                }
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
        if (bCloseConnection) {
            this.closeConnection(connection);
        }
        return n;
    }

    public void unregisterNewContainerInstance(Connection connection, String sComponentId, String sContainerType, String sContentType) throws ContainerManagerException {
        boolean bCloseConnection = false;
        this.checkParameters(sComponentId, sContainerType, sContentType);
        PreparedStatement prepStmt = null;
        try {
            if (connection == null) {
                connection = DBUtil.makeConnection(m_dbName);
                bCloseConnection = true;
            }
            String sSQLStatement = "DELETE FROM " + m_sInstanceTable + " WHERE (";
            sSQLStatement = sSQLStatement + "componentId = '" + sComponentId + "') AND (containerType = '" + sContainerType + "') AND (contentType = '" + sContentType + "')";
            SilverTrace.info("containerManager", "ContainerManager.unregisterNewContainerInstance", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            prepStmt.executeUpdate();
            this.removeAsso(sComponentId);
        }
        catch (Exception e) {
            try {
                throw new ContainerManagerException("ContainerManager.unregisterNewContainerInstance", 4, "containerManager.EX_CANT_UNREGISTER_CONTAINER_INSTANCE", "componentId: " + sComponentId + "    sContainerType: " + sContainerType, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                if (bCloseConnection) {
                    this.closeConnection(connection);
                }
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
        if (bCloseConnection) {
            this.closeConnection(connection);
        }
    }

    public ContainerPeas getContainerPeas(String componentId) throws ContainerManagerException {
        String sContainerType = this.getContainerType(componentId);
        for (ContainerPeas s_acContainerPea : s_acContainerPeas) {
            if (!s_acContainerPea.getType().equals(sContainerType)) continue;
            return s_acContainerPea;
        }
        return null;
    }

    private String getContainerType(String componentId) throws ContainerManagerException {
        String sSQLStatement = "SELECT containerType FROM " + m_sInstanceTable + " WHERE (componentId = '" + componentId + "')";
        String sContainerType = this.getFirstStringValue(sSQLStatement);
        return sContainerType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerPeas getContainerPeas(Connection connection, int nContainerInstanceId) throws Exception {
        String sSQLStatement = "SELECT * FROM " + m_sInstanceTable + " WHERE( instanceId = " + nContainerInstanceId + ")";
        SilverTrace.info("containerManager", "ContainerManager.getContainerPeas", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
        String sContainerType = null;
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement(sSQLStatement);
            ResultSet resSet = prepStmt.executeQuery();
            while (resSet.next() && sContainerType == null) {
                sContainerType = resSet.getString(3);
            }
        }
        finally {
            DBUtil.close(prepStmt);
        }
        return this.getContainerPeasByType(sContainerType);
    }

    public ContainerPeas getContainerPeasByType(String sContainerType) throws ContainerManagerException {
        for (int nI = 0; s_acContainerPeas != null && nI < s_acContainerPeas.size(); ++nI) {
            if (!s_acContainerPeas.get(nI).getType().equals(sContainerType)) continue;
            return s_acContainerPeas.get(nI);
        }
        throw new ContainerManagerException("ContainerManager.getContainerPeas", 4, "containerManager.EX_CANT_FIND_CONTAINERPEAS");
    }

    public int getContainerInstanceId(String sComponentId) throws ContainerManagerException {
        this.checkComponentId(sComponentId);
        int containerInstanceId = -1;
        String sContainerInstanceId = this.getInstanceId(sComponentId);
        if (sContainerInstanceId != null) {
            containerInstanceId = Integer.parseInt(sContainerInstanceId);
        } else {
            String componentName = this.extractComponentNameFromInstanceId(sComponentId);
            containerInstanceId = this.registerNewContainerInstance(null, sComponentId, "containerPDC", componentName);
        }
        SilverTrace.info("containerManager", "ContainerManager.getContainerInstanceId", "root.MSG_GEN_PARAM_VALUE", "getAsso().size() = " + this.getAsso().size());
        return containerInstanceId;
    }

    private String extractComponentNameFromInstanceId(String instanceId) {
        StringBuffer componentName = new StringBuffer();
        for (int i = 0; i < instanceId.length(); ++i) {
            char character = instanceId.charAt(i);
            if (character != '0' && character != '1' && character != '2' && character != '3' && character != '4' && character != '5' && character != '6' && character != '7' && character != '8' && character != '9') continue;
            SilverTrace.info("containerManager", "ContainerManager.extractComponentNameFromInstanceId", "root.MSG_GEN_PARAM_VALUE", "componentName = " + componentName);
            return instanceId.substring(0, i);
        }
        return instanceId;
    }

    private Hashtable<String, String> getAsso() {
        return assoComponentIdInstanceId;
    }

    private String getInstanceId(String componentId) {
        return this.getAsso().get(componentId);
    }

    private void addAsso(String componentId, int instanceId) {
        this.getAsso().put(componentId, Integer.toString(instanceId));
    }

    private void removeAsso(String componentId) {
        this.getAsso().remove(componentId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Hashtable<String, String> loadAsso(Connection connection) throws ContainerManagerException {
        boolean bCloseConnection = false;
        PreparedStatement prepStmt = null;
        ResultSet resSet = null;
        Hashtable<String, String> tempAsso = new Hashtable<String, String>();
        try {
            if (connection == null) {
                connection = DBUtil.makeConnection(m_dbName);
                bCloseConnection = true;
            }
            String sSQLStatement = "SELECT instanceId, componentId FROM " + m_sInstanceTable;
            SilverTrace.info("containerManager", "ContainerManager.loadAsso", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            resSet = prepStmt.executeQuery();
            while (resSet.next()) {
                tempAsso.put(resSet.getString(2), Integer.toString(resSet.getInt(1)));
            }
        }
        catch (Exception e) {
            try {
                throw new ContainerManagerException("ContainerManager.loadAsso", 4, "containerManager.EX_CANT_LOAD_ASSO_CACHE", "", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resSet, prepStmt);
                try {
                    if (!bCloseConnection) throw throwable;
                    if (connection == null) throw throwable;
                    connection.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    SilverTrace.error("containerManager", "ContainerManager.loadAsso", "root.EX_CONNECTION_CLOSE_FAILED", "", e2);
                }
                throw throwable;
            }
        }
        DBUtil.close(resSet, prepStmt);
        try {
            if (!bCloseConnection) return tempAsso;
            if (connection == null) return tempAsso;
            connection.close();
            return tempAsso;
        }
        catch (Exception e) {
            SilverTrace.error("containerManager", "ContainerManager.loadAsso", "root.EX_CONNECTION_CLOSE_FAILED", "", e);
            return tempAsso;
        }
    }

    public void silverContentIsRemoved(Connection connection, int nSilverContentId, int nContainerInstanceId) throws ContainerManagerException {
        StringBuffer sSQLStatement = new StringBuffer(1000);
        boolean bCloseConnection = false;
        PreparedStatement prepStmt = null;
        try {
            ContainerPeas containerPeas;
            ContainerInterface containerInterface;
            List<Integer> alPositions;
            if (connection == null) {
                connection = DBUtil.makeConnection(m_dbName);
                connection.setAutoCommit(false);
                bCloseConnection = true;
            }
            if ((alPositions = (containerInterface = (containerPeas = this.getContainerPeas(connection, nContainerInstanceId)).getContainerInterface()).removePosition(connection, nSilverContentId)).size() > 0) {
                sSQLStatement.append("DELETE FROM ").append(this.m_sLinksTable).append(" WHERE ");
                for (int nI = 0; nI < alPositions.size(); ++nI) {
                    sSQLStatement.append("(positionId = ").append(alPositions.get(nI).toString()).append(")");
                    if (nI >= alPositions.size() - 1) continue;
                    sSQLStatement.append(" OR ");
                }
                SilverTrace.info("containerManager", "ContainerManager.silverContentIsRemoved", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
                prepStmt = connection.prepareStatement(sSQLStatement.toString());
                prepStmt.executeUpdate();
            }
            if (bCloseConnection) {
                connection.commit();
            }
        }
        catch (Exception e) {
            if (bCloseConnection) {
                this.rollbackConnection(connection);
            }
            throw new ContainerManagerException("ContainerManager.silverContentIsRemoved", 4, "containerManager.EX_CANT_REMOVE_SILVERCONTENT", "nSilverContentId: " + nSilverContentId + "   nContainerInstanceId: " + nContainerInstanceId, e);
        }
        finally {
            DBUtil.close(prepStmt);
            if (bCloseConnection) {
                this.closeConnection(connection);
            }
        }
    }

    private void checkParameters(String sComponentId, String sContainerType, String sContentType) throws ContainerManagerException {
        this.checkComponentId(sComponentId);
        if (sContainerType == null) {
            throw new ContainerManagerException("ContainerManager.checkParameters", 4, "containerManager.EX_CONTAINERTYPE_NULL");
        }
        if (sContainerType.length() == 0) {
            throw new ContainerManagerException("ContainerManager.checkParameters", 4, "containerManager.EX_CONTAINERTYPE_EMPTY");
        }
        if (sContentType == null) {
            throw new ContainerManagerException("ContainerManager.checkParameters", 4, "containerManager.EX_CONTENTTYPE_NULL");
        }
        if (sContentType.length() == 0) {
            throw new ContainerManagerException("ContainerManager.checkParameters", 4, "containerManager.EX_CONTENTTYPE_EMPTY");
        }
    }

    private void checkComponentId(String sComponentId) throws ContainerManagerException {
        if (sComponentId == null) {
            throw new ContainerManagerException("ContainerManager.checkParameters", 4, "containerManager.EX_COMPONENTID_NULL");
        }
        if (sComponentId.length() == 0) {
            throw new ContainerManagerException("ContainerManager.checkParameters", 4, "containerManager.EX_COMPONENTID_EMPTY");
        }
    }

    private String getFirstStringValue(String sSQLStatement) throws ContainerManagerException {
        String string;
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resSet = null;
        try {
            String sValue = null;
            connection = DBUtil.makeConnection(m_dbName);
            SilverTrace.info("containerManager", "ContainerManager.getFirstStringValue", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            resSet = prepStmt.executeQuery();
            while (resSet.next() && sValue == null) {
                sValue = resSet.getString(1);
            }
            string = sValue;
        }
        catch (Exception e) {
            try {
                throw new ContainerManagerException("ContainerManager.getFirstStringValue", 4, "containerManager.EX_CANT_QUERY_DATABASE", "sSQLStatement: " + sSQLStatement, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resSet, prepStmt);
                this.closeConnection(connection);
                throw throwable;
            }
        }
        DBUtil.close(resSet, prepStmt);
        this.closeConnection(connection);
        return string;
    }

    public void addContainerContentInstanceLink(Connection connection, int nPositionId, String sComponentId) throws ContainerManagerException {
        PreparedStatement prepStmt = null;
        try {
            int nContainerInstanceId = this.getContainerInstanceId(sComponentId);
            String sSQLStatement = "INSERT INTO " + this.m_sLinksTable + " (positionId, containerInstanceId) VALUES(" + nPositionId + ", " + nContainerInstanceId + ")";
            SilverTrace.info("containerManager", "ContainerManager.addContainerContentInstanceLink", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new ContainerManagerException("ContainerManager.addContainerContentInstanceLink", 4, "containerManager.EX_CANT_ADDLINK_CONTAINER_POSITION", "nPositionId: " + nPositionId + "componentId: " + sComponentId, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
    }

    public void removeContainerContentInstanceLink(Connection connection, int nPositionId, String sComponentId) throws ContainerManagerException {
        PreparedStatement prepStmt = null;
        try {
            int nContainerInstanceId = this.getContainerInstanceId(sComponentId);
            String sSQLStatement = "DELETE FROM " + this.m_sLinksTable + " WHERE (positionId = " + nPositionId + ") AND (containerInstanceId = " + nContainerInstanceId + ")";
            SilverTrace.info("containerManager", "ContainerManager.removeContainerContentInstanceLink", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new ContainerManagerException("ContainerManager.removeContainerContentInstanceLink", 4, "containerManager.EX_CANT_REMOVELINK_CONTAINER_POSITION", "nPositionId: " + nPositionId + "componentId: " + sComponentId, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
    }

    public void removeAllPositionIdsLink(Connection connection, List<Integer> alPositionIds) throws ContainerManagerException {
        StringBuffer sSQLStatement = new StringBuffer(1000);
        PreparedStatement prepStmt = null;
        try {
            if (alPositionIds != null && alPositionIds.size() > 0) {
                sSQLStatement.append("DELETE FROM ").append(this.m_sLinksTable).append(" WHERE ");
                for (int nI = 0; nI < alPositionIds.size(); ++nI) {
                    sSQLStatement.append("(positionId = ").append(alPositionIds.get(nI)).append(")");
                    if (nI >= alPositionIds.size() - 1) continue;
                    sSQLStatement.append(" OR ");
                }
                SilverTrace.info("containerManager", "ContainerManager.removeAllPositionIdsLink", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
                prepStmt = connection.prepareStatement(sSQLStatement.toString());
                prepStmt.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new ContainerManagerException("ContainerManager.removeAllPositionIdsLink", 4, "containerManager.EX_CANT_REMOVEALLLINK_POSITIONIDS", "", e);
        }
        finally {
            DBUtil.close(prepStmt);
        }
    }

    public JoinStatement getFilterPositionsByComponentIdStatement(List<Integer> alPositions, List<String> alComponentId) throws ContainerManagerException {
        StringBuffer sSQLStatement = new StringBuffer(1000);
        JoinStatement joinStatement = new JoinStatement();
        ArrayList<String> alGivenTables = new ArrayList<String>();
        ArrayList<String> alGivenKeys = new ArrayList<String>();
        alGivenTables.add(this.m_sLinksTable);
        alGivenKeys.add("positionId");
        alGivenTables.add(m_sInstanceTable);
        alGivenKeys.add("instanceId");
        joinStatement.setTables(alGivenTables);
        joinStatement.setJoinKeys(alGivenKeys);
        if (alComponentId != null && alComponentId.size() > 0) {
            sSQLStatement.append(" CML.containerInstanceId IN (");
            boolean first = true;
            for (String component : alComponentId) {
                int nContainerInstanceId = this.getContainerInstanceId(component);
                if (nContainerInstanceId == -1) continue;
                if (!first) {
                    sSQLStatement.append(", ");
                } else {
                    first = false;
                }
                sSQLStatement.append(nContainerInstanceId);
            }
            sSQLStatement.append(") ");
        }
        if (alPositions != null && alPositions.size() > 0) {
            sSQLStatement.append(" AND (");
        }
        for (int nI = 0; alPositions != null && nI < alPositions.size(); ++nI) {
            sSQLStatement.append("CML.positionId = ").append(alPositions.get(nI).toString());
            if (nI < alPositions.size() - 1) {
                sSQLStatement.append(" OR ");
                continue;
            }
            sSQLStatement.append(")");
        }
        joinStatement.setWhere(sSQLStatement.toString());
        SilverTrace.info("containerManager", "ContainerManager.getFilterPositionsByComponentIdStatement", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
        return joinStatement;
    }

    public List<Integer> filterPositionsByComponentId(List<Integer> alPositions, String sComponentId) throws ContainerManagerException {
        ArrayList<Integer> arrayList;
        StringBuffer sSQLStatement = new StringBuffer(1000);
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resSet = null;
        try {
            connection = DBUtil.makeConnection(m_dbName);
            int nContainerInstanceId = this.getContainerInstanceId(sComponentId);
            sSQLStatement.append("SELECT positionId FROM ").append(this.m_sLinksTable).append(" WHERE (containerInstanceId = ").append(nContainerInstanceId).append(")");
            if (alPositions != null && alPositions.size() > 0) {
                sSQLStatement.append(" AND (");
            }
            for (int nI = 0; alPositions != null && nI < alPositions.size(); ++nI) {
                sSQLStatement.append("positionId = ").append(alPositions.get(nI).toString());
                if (nI < alPositions.size() - 1) {
                    sSQLStatement.append(" OR ");
                    continue;
                }
                sSQLStatement.append(")");
            }
            SilverTrace.info("containerManager", "ContainerManager.filterPositionsByComponentId", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement.toString());
            resSet = prepStmt.executeQuery();
            ArrayList<Integer> alFilteredPositions = new ArrayList<Integer>();
            while (resSet.next()) {
                alFilteredPositions.add(resSet.getInt(1));
            }
            arrayList = alFilteredPositions;
        }
        catch (Exception e) {
            try {
                throw new ContainerManagerException("ContainerManager.filterPositionsByComponentId", 4, "containerManager.EX_CANT_FILTER_POSITIONS", "componentId: " + sComponentId, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resSet, prepStmt);
                this.closeConnection(connection);
                throw throwable;
            }
        }
        DBUtil.close(resSet, prepStmt);
        this.closeConnection(connection);
        return arrayList;
    }

    private void rollbackConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (Exception e) {
            SilverTrace.error("containerManager", "ContainerManager.rollbackConnection()", "root.EX_CONNECTION_CLOSE_FAILED", "", e);
        }
    }

    private void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            SilverTrace.error("containerManager", "ContainerManager.closeConnection", "root.EX_CONNECTION_CLOSE_FAILED", e);
        }
    }

    static {
        try {
            assoComponentIdInstanceId = new Hashtable<String, String>(ContainerManager.loadAsso(null));
        }
        catch (ContainerManagerException e) {
            SilverTrace.error("containerManager", "ContainerManager.initStatic", "root.EX_CLASS_NOT_INITIALIZED", "assoComponentIdInstanceId initialization failed !", e);
        }
    }
}

