/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.contentManager;

import com.stratelia.silverpeas.containerManager.ContainerManager;
import com.stratelia.silverpeas.containerManager.URLIcone;
import com.stratelia.silverpeas.contentManager.ContentManagerException;
import com.stratelia.silverpeas.contentManager.ContentPeas;
import com.stratelia.silverpeas.contentManager.SilverContent;
import com.stratelia.silverpeas.contentManager.SilverContentVisibility;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.JoinStatement;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Named;

@Named(value="contentManager")
public class ContentManager
implements Serializable {
    private static final List<ContentPeas> s_acContentPeas = new ArrayList<ContentPeas>();
    private static Map<String, String> assoComponentIdInstanceId;
    private static HashMap<String, String> assoSilverContentIdInternalComponentId;
    private static String m_dbName;
    private static String m_sInstanceTable;
    private static final long serialVersionUID = 7069917496138130066L;
    private String m_sSilverContentTable = "SB_ContentManager_Content";
    private ContainerManager m_containerManager = null;

    public ContentManager() throws ContentManagerException {
        try {
            this.m_containerManager = new ContainerManager();
        }
        catch (Exception e) {
            throw new ContentManagerException("ContentManager.ContentManager", 4, "contentManager.EX_CANT_INSTANCIATE_CONTAINERMANAGER", "", e);
        }
    }

    public int registerNewContentInstance(Connection connection, String sComponentId, String sContainerType, String sContentType) throws ContentManagerException {
        int n;
        boolean bCloseConnection = false;
        this.checkParameters(sComponentId, sContainerType, sContentType);
        PreparedStatement prepStmt = null;
        try {
            if (connection == null) {
                connection = DBUtil.makeConnection(m_dbName);
                bCloseConnection = true;
            }
            int newInstanceId = DBUtil.getNextId(m_sInstanceTable, "instanceId");
            String sSQLStatement = "INSERT INTO " + m_sInstanceTable + "(instanceId, componentId, containerType, contentType) ";
            sSQLStatement = sSQLStatement + "VALUES (" + newInstanceId + ",'" + sComponentId + "','" + sContainerType + "','" + sContentType + "')";
            SilverTrace.info("contentManager", "ContentManager.registerNewContentInstance", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            prepStmt.executeUpdate();
            this.addAsso(sComponentId, newInstanceId);
            n = newInstanceId;
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("ContentManager.registerNewContentInstance", 4, "contentManager.EX_CANT_REGISTER_CONTENT_INSTANCE", "sComponentId: " + sComponentId + "    sContentType: " + sContentType, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                if (bCloseConnection) {
                    this.closeConnection(connection);
                }
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
        if (bCloseConnection) {
            this.closeConnection(connection);
        }
        return n;
    }

    private void closeConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            SilverTrace.error("contentManager", "ContentManager.closeConnection", "root.EX_CONNECTION_CLOSE_FAILED", "", e);
        }
    }

    public void unregisterNewContentInstance(Connection connection, String sComponentId, String sContainerType, String sContentType) throws ContentManagerException {
        boolean bCloseConnection = false;
        this.checkParameters(sComponentId, sContainerType, sContentType);
        PreparedStatement prepStmt = null;
        try {
            if (connection == null) {
                connection = DBUtil.makeConnection(m_dbName);
                bCloseConnection = true;
            }
            String sSQLStatement = "DELETE FROM " + m_sInstanceTable + " WHERE (";
            sSQLStatement = sSQLStatement + "componentId = '" + sComponentId + "') AND (containerType = '" + sContainerType + "') AND (contentType = '" + sContentType + "')";
            SilverTrace.info("contentManager", "ContentManager.unregisterNewContentInstance", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            prepStmt.executeUpdate();
            this.removeAsso(sComponentId);
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("ContentManager.unregisterNewContentInstance", 4, "contentManager.EX_CANT_UNREGISTER_CONTENT_INSTANCE", "sComponentId: " + sComponentId + "    sContentType: " + sContentType, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                if (bCloseConnection) {
                    this.closeConnection(connection);
                }
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
        if (bCloseConnection) {
            this.closeConnection(connection);
        }
    }

    public ContentPeas getContentPeas(String sComponentId) throws ContentManagerException {
        String sContentType = this.getContentType(sComponentId);
        SilverTrace.info("contentManager", "ContentManager.getContentPeas", "", "sContentType= " + sContentType + " sComponentId=" + sComponentId);
        for (ContentPeas s_acContentPea : s_acContentPeas) {
            SilverTrace.info("contentManager", "ContentManager.getContentPeas", "", "Type= " + s_acContentPea.getType());
            if (!s_acContentPea.getType().equals(sContentType)) continue;
            SilverTrace.info("contentManager", "ContentManager.getContentPeas", "", "Type Trouv\u00e9= " + s_acContentPea.getType() + "   " + sContentType);
            return s_acContentPea;
        }
        SilverTrace.info("contentManager", "ContentManager.getContentPeas", "contentManager.EX_UNKNOWN_CONTENT_PEAS", "sComponentId: " + sComponentId);
        return null;
    }

    private String getContentType(String componentId) throws ContentManagerException {
        String sSQLStatement = "SELECT contentType FROM " + m_sInstanceTable + " WHERE (componentId = '" + componentId + "')";
        String sContentType = this.getFirstStringValue(sSQLStatement);
        return sContentType;
    }

    public List<URLIcone> getContentURLIcones(String sContentType, List<String> asUserContentRoles) {
        ArrayList<URLIcone> auURLIcones = new ArrayList<URLIcone>();
        if (sContentType.equals("fileBoxPlus")) {
            boolean publisher = false;
            boolean admin = false;
            Iterator<String> iter = asUserContentRoles.iterator();
            String userRole = "";
            while (iter.hasNext()) {
                userRole = iter.next();
                if ("admin".equals(userRole)) {
                    admin = true;
                    continue;
                }
                if (!"publisher".equals(userRole)) continue;
                publisher = true;
            }
            if (admin || publisher) {
                URLIcone uiCreation = new URLIcone();
                uiCreation.setIconePath(URLManager.getApplicationURL() + "/util/icons/publicationAdd.gif");
                uiCreation.setAlternateText("fileBoxPlus.CreateNewDocument");
                uiCreation.setActionURL("CreateQuery");
                auURLIcones.add(uiCreation);
                uiCreation = new URLIcone();
                uiCreation.setIconePath(URLManager.getApplicationURL() + "/util/icons/publish.gif");
                uiCreation.setAlternateText("fileBoxPlus.AllDocuments");
                uiCreation.setActionURL("Main");
                auURLIcones.add(uiCreation);
            }
        } else if (sContentType.equals("whitePages")) {
            boolean admin = false;
            Iterator<String> iter = asUserContentRoles.iterator();
            String userRole = "";
            while (iter.hasNext()) {
                userRole = iter.next();
                if (!"admin".equals(userRole)) continue;
                admin = true;
            }
            if (admin) {
                URLIcone uiCreation = new URLIcone();
                uiCreation.setIconePath(URLManager.getApplicationURL() + "/util/icons/whitePages_to_add.gif");
                uiCreation.setAlternateText("whitePages.CreateAUsercard");
                uiCreation.setActionURL("createQuery");
                auURLIcones.add(uiCreation);
                uiCreation = new URLIcone();
                uiCreation.setIconePath(URLManager.getApplicationURL() + "/util/icons/publish.gif");
                uiCreation.setAlternateText("whitePages.AllCards");
                uiCreation.setActionURL("Main");
                auURLIcones.add(uiCreation);
            }
        } else if (sContentType.equals("expertLocator")) {
            boolean admin = false;
            Iterator<String> iter = asUserContentRoles.iterator();
            String userRole = "";
            while (iter.hasNext()) {
                userRole = iter.next();
                if (!"admin".equals(userRole)) continue;
                admin = true;
            }
            if (admin) {
                URLIcone uiCreation = new URLIcone();
                uiCreation.setIconePath(URLManager.getApplicationURL() + "/util/icons/expertLocator_to_add.gif");
                uiCreation.setAlternateText("expertLocator.CreateAUsercard");
                uiCreation.setActionURL("createQuery");
                auURLIcones.add(uiCreation);
                uiCreation = new URLIcone();
                uiCreation.setIconePath(URLManager.getApplicationURL() + "/util/icons/publish.gif");
                uiCreation.setAlternateText("expertLocator.AllCards");
                uiCreation.setActionURL("Main");
                auURLIcones.add(uiCreation);
            }
        } else if (sContentType.equals("questionReply")) {
            boolean admin = false;
            boolean publisher = false;
            Iterator<String> iter = asUserContentRoles.iterator();
            String userRole = "";
            while (iter.hasNext()) {
                userRole = iter.next();
                if ("admin".equals(userRole) || "writer".equals(userRole)) {
                    admin = true;
                }
                if (!"publisher".equals(userRole)) continue;
                publisher = true;
            }
            if (admin) {
                URLIcone uiCreation = new URLIcone();
                uiCreation.setIconePath(URLManager.getApplicationURL() + "/util/icons/questionReply_addQ.gif");
                uiCreation.setAlternateText("questionReply.AriseAQuestion");
                uiCreation.setActionURL("CreateQQuery");
                auURLIcones.add(uiCreation);
                uiCreation = new URLIcone();
                uiCreation.setIconePath(URLManager.getApplicationURL() + "/util/icons/questionReply_addQR.gif");
                uiCreation.setAlternateText("questionReply.AddAFAQ");
                uiCreation.setActionURL("CreateQueryQR");
                auURLIcones.add(uiCreation);
                uiCreation = new URLIcone();
                uiCreation.setIconePath(URLManager.getApplicationURL() + "/util/icons/questionReply_viewList.gif");
                uiCreation.setAlternateText("questionReply.AllQuestions");
                uiCreation.setActionURL("ConsultReceiveQuestions");
                auURLIcones.add(uiCreation);
            } else if (publisher) {
                URLIcone uiCreation = new URLIcone();
                uiCreation.setIconePath(URLManager.getApplicationURL() + "/util/icons/questionReply_addQ.gif");
                uiCreation.setAlternateText("questionReply.AriseAQuestion");
                uiCreation.setActionURL("CreateQQuery");
                auURLIcones.add(uiCreation);
                uiCreation = new URLIcone();
                uiCreation.setIconePath(URLManager.getApplicationURL() + "/util/icons/questionReply_viewList.gif");
                uiCreation.setAlternateText("questionReply.AllQuestions");
                uiCreation.setActionURL("ConsultReceiveQuestions");
                auURLIcones.add(uiCreation);
            }
        } else if (sContentType.equals("contentFB") && asUserContentRoles.get(0).equals("ContentRole_fileBoxPlus_admin")) {
            URLIcone uiCreation = new URLIcone();
            uiCreation.setIconePath("");
            uiCreation.setActionURL("Main");
            auURLIcones.add(uiCreation);
        }
        return auURLIcones;
    }

    private void checkParameters(String sComponentId, String sContainerType, String sContentType) throws ContentManagerException {
        if (sComponentId == null) {
            throw new ContentManagerException("ContentManager.checkParameters", 4, "contentManager.EX_COMPONENTID_NULL");
        }
        if (sComponentId.length() == 0) {
            throw new ContentManagerException("ContentManager.checkParameters", 4, "contentManager.EX_COMPONENTID_EMPTY");
        }
        if (sContainerType == null) {
            throw new ContentManagerException("ContentManager.checkParameters", 4, "contentManager.EX_CONTAINERTYPE_NULL");
        }
        if (sContainerType.length() == 0) {
            throw new ContentManagerException("ContentManager.checkParameters", 4, "contentManager.EX_CONTAINERTYPE_EMPTY");
        }
        if (sContentType == null) {
            throw new ContentManagerException("ContentManager.checkParameters", 4, "contentManager.EX_CONTENTTYPE_NULL");
        }
        if (sContentType.length() == 0) {
            throw new ContentManagerException("ContentManager.checkParameters", 4, "contentManager.EX_CONTENTTYPE_EMPTY");
        }
    }

    private String getFirstStringValue(String sSQLStatement) throws ContentManagerException {
        String string;
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resSet = null;
        try {
            String sValue = null;
            connection = DBUtil.makeConnection(m_dbName);
            SilverTrace.info("contentManager", "ContentManager.getFirstStringValue", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            resSet = prepStmt.executeQuery();
            while (resSet.next() && sValue == null) {
                sValue = resSet.getString(1);
            }
            string = sValue;
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("ContentManager.getFirstStringValue", 4, "contentManager.EX_CANT_QUERY_DATABASE", "sSQLStatement: " + sSQLStatement, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resSet, prepStmt);
                this.closeConnection(connection);
                throw throwable;
            }
        }
        DBUtil.close(resSet, prepStmt);
        this.closeConnection(connection);
        return string;
    }

    public int addSilverContent(Connection connection, String sInternalContentId, String sComponentId, String sAuthorId) throws ContentManagerException {
        return this.addSilverContent(connection, sInternalContentId, sComponentId, sAuthorId, null);
    }

    public int addSilverContent(Connection connection, String sInternalContentId, String sComponentId, String sAuthorId, SilverContentVisibility scv) throws ContentManagerException {
        int n;
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        Date systemDate = new Date(time);
        boolean bCloseConnection = false;
        if (scv == null) {
            scv = new SilverContentVisibility();
        }
        PreparedStatement prepStmt = null;
        try {
            if (connection == null) {
                connection = DBUtil.makeConnection(m_dbName);
                bCloseConnection = true;
            }
            int nContentInstanceId = this.getContentInstanceId(sComponentId);
            SilverTrace.info("contentManager", "ContentManager.addSilverContent", "root.MSG_GEN_PARAM_VALUE", "nContentInstanceId= " + nContentInstanceId);
            int newSilverContentId = DBUtil.getNextId(this.m_sSilverContentTable, "silverContentId");
            SilverTrace.info("contentManager", "ContentManager.addSilverContent", "root.MSG_GEN_PARAM_VALUE", "newSilverContentId= " + newSilverContentId);
            String sSQLStatement = "INSERT INTO " + this.m_sSilverContentTable + "(silverContentId, internalContentId, contentInstanceid, authorId, creationDate, beginDate, endDate, isVisible) ";
            sSQLStatement = sSQLStatement + "VALUES (" + newSilverContentId + ",'" + sInternalContentId + "'," + nContentInstanceId + "," + Integer.parseInt(sAuthorId) + ",?, ? , ? , ? )";
            SilverTrace.info("contentManager", "ContentManager.addSilverContent", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            prepStmt.setDate(1, systemDate);
            prepStmt.setString(2, scv.getBeginDate());
            prepStmt.setString(3, scv.getEndDate());
            prepStmt.setInt(4, scv.isVisible());
            prepStmt.executeUpdate();
            n = newSilverContentId;
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("ContentManager.addSilverContent", 4, "contentManager.EX_CANT_ADD_SILVER_CONTENT", "sInternalContentId: " + sInternalContentId + "    sComponentId: " + sComponentId, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                if (bCloseConnection) {
                    this.closeConnection(connection);
                }
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
        if (bCloseConnection) {
            this.closeConnection(connection);
        }
        return n;
    }

    public void removeSilverContent(Connection connection, int nSilverContentId, String sComponentId) throws ContentManagerException {
        PreparedStatement prepStmt = null;
        try {
            String sSQLStatement = "DELETE FROM " + this.m_sSilverContentTable + " WHERE (silverContentId = " + nSilverContentId + ")";
            SilverTrace.info("contentManager", "ContentManager.removeSilverContent", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            prepStmt.executeUpdate();
            this.m_containerManager.silverContentIsRemoved(connection, nSilverContentId, this.m_containerManager.getContainerInstanceId(sComponentId));
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("ContentManager.removeSilverContent", 4, "contentManager.EX_CANT_REMOVE_SILVER_CONTENT", "nSilverContentId: " + nSilverContentId + "   sComponentId: " + sComponentId, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                throw throwable;
            }
        }
        DBUtil.close(prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSilverContentId(Statement stmt, String sInternalContentId, String sComponentId, boolean isGlobalSearch) throws ContentManagerException {
        ResultSet resSet = null;
        StringBuffer sSQLStatement = new StringBuffer();
        int nSilverContentId = -1;
        try {
            sSQLStatement.append("SELECT silverContentId FROM ").append(this.m_sSilverContentTable);
            sSQLStatement.append(" WHERE (internalContentId = '").append(sInternalContentId).append("') AND (contentInstanceId = ");
            if (isGlobalSearch) {
                sSQLStatement.append(" (select instanceId from ").append(m_sInstanceTable).append(" where componentId='").append(sComponentId).append("') ) ");
            } else {
                sSQLStatement.append(this.getContentInstanceId(sComponentId)).append(") ");
            }
            SilverTrace.info("contentManager", "ContentManager.getSilverContentId", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            resSet = stmt.executeQuery(sSQLStatement.toString());
            if (resSet.next()) {
                nSilverContentId = resSet.getInt(1);
            }
            DBUtil.close(resSet);
        }
        catch (SQLException excep_select) {
            SilverTrace.warn("contentManager", "ContentManager.getSilverContentId", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
        }
        finally {
            DBUtil.close(resSet);
        }
        return nSilverContentId;
    }

    public int getSilverContentId(String sInternalContentId, String sComponentId) throws ContentManagerException {
        int n;
        Connection connection = null;
        Statement stmt = null;
        try {
            int silverContentId;
            connection = DBUtil.makeConnection(m_dbName);
            stmt = connection.createStatement();
            n = silverContentId = this.getSilverContentId(stmt, sInternalContentId, sComponentId, false);
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("ContentManager.getSilverContentId", 4, "contentManager.EX_CANT_GET_SILVERCONTENTID", "sComponentId: " + sComponentId + "    sInternalContentId: " + sInternalContentId, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(stmt);
                this.closeConnection(connection);
                throw throwable;
            }
        }
        DBUtil.close(stmt);
        this.closeConnection(connection);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SortedSet<Integer> getSilverContentId(List<String> documentFeature) throws ContentManagerException {
        TreeSet<Integer> i2;
        Connection connection = null;
        Statement stmt = null;
        TreeSet<Integer> alSilverContentId = new TreeSet<Integer>();
        String sInternalContentId = "";
        String sComponentId = "";
        try {
            connection = DBUtil.makeConnection(m_dbName);
            stmt = connection.createStatement();
            for (int i2 = 0; i2 < documentFeature.size(); i2 += 2) {
                sInternalContentId = documentFeature.get(i2);
                int silverContentId = this.getSilverContentId(stmt, sInternalContentId, sComponentId = documentFeature.get(i2 + 1), true);
                if (silverContentId == -1) continue;
                alSilverContentId.add(silverContentId);
            }
            i2 = alSilverContentId;
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("ContentManager.getSilverContentId", 4, "contentManager.EX_CANT_GET_SILVERCONTENTID", "sComponentId: " + sComponentId + "    sInternalContentId: " + sInternalContentId, e);
            }
            catch (Throwable throwable) {
                try {
                    DBUtil.close(stmt);
                    if (connection == null) throw throwable;
                    connection.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    SilverTrace.error("contentManager", "ContentManager.getSilverContentId", "root.EX_CONNECTION_CLOSE_FAILED", "", e2);
                }
                throw throwable;
            }
        }
        try {
            DBUtil.close(stmt);
            if (connection == null) return i2;
            connection.close();
            return i2;
        }
        catch (Exception e) {
            SilverTrace.error("contentManager", "ContentManager.getSilverContentId", "root.EX_CONNECTION_CLOSE_FAILED", "", e);
        }
        return i2;
    }

    private String getInternalContentIdFromCache(String sSilverContentId) {
        return assoSilverContentIdInternalComponentId.get(sSilverContentId);
    }

    private void putInternalContentIdIntoCache(String sSilverContentId, String sInternalContentId) {
        assoSilverContentIdInternalComponentId.put(sSilverContentId, sInternalContentId);
    }

    public String getInternalContentId(int nSilverContentId) throws ContentManagerException {
        String sSilverContentId = String.valueOf(nSilverContentId);
        String sInternalContentId = this.getInternalContentIdFromCache(sSilverContentId);
        if (sInternalContentId == null) {
            Connection connection = null;
            PreparedStatement prepStmt = null;
            ResultSet resSet = null;
            try {
                connection = DBUtil.makeConnection(m_dbName);
                String sSQLStatement = "SELECT internalContentId FROM " + this.m_sSilverContentTable + " WHERE (silverContentId = " + nSilverContentId + ")";
                SilverTrace.info("contentManager", "ContentManager.getInternalContentId", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
                prepStmt = connection.prepareStatement(sSQLStatement);
                resSet = prepStmt.executeQuery();
                if (resSet.next()) {
                    sInternalContentId = resSet.getString(1);
                }
                this.putInternalContentIdIntoCache(sSilverContentId, sInternalContentId);
            }
            catch (Exception e) {
                try {
                    throw new ContentManagerException("ContentManager.getInternalContentId", 4, "contentManager.EX_CANT_GET_INTERNALCONTENTID", "nSilverContentId: " + nSilverContentId, e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(resSet, prepStmt);
                    this.closeConnection(connection);
                    throw throwable;
                }
            }
            DBUtil.close(resSet, prepStmt);
            this.closeConnection(connection);
        }
        return sInternalContentId;
    }

    public int getContentInstanceId(String sComponentId) throws ContentManagerException {
        int contentInstanceId = -1;
        String sContentInstanceId = this.getInstanceId(sComponentId);
        if (sContentInstanceId != null) {
            contentInstanceId = Integer.parseInt(sContentInstanceId);
        } else {
            String componentName = this.extractComponentNameFromInstanceId(sComponentId);
            contentInstanceId = this.registerNewContentInstance(null, sComponentId, "containerPDC", componentName);
        }
        return contentInstanceId;
    }

    private String extractComponentNameFromInstanceId(String instanceId) {
        StringBuffer componentName = new StringBuffer();
        for (int i = 0; i < instanceId.length(); ++i) {
            char character = instanceId.charAt(i);
            if (character != '0' && character != '1' && character != '2' && character != '3' && character != '4' && character != '5' && character != '6' && character != '7' && character != '8' && character != '9') continue;
            SilverTrace.info("contentManager", "ContentManager.extractComponentNameFromInstanceId", "root.MSG_GEN_PARAM_VALUE", "componentName = " + componentName);
            return instanceId.substring(0, i);
        }
        return instanceId;
    }

    private Map<String, String> getAsso() {
        return assoComponentIdInstanceId;
    }

    private String getInstanceId(String componentId) {
        return this.getAsso().get(componentId);
    }

    private void addAsso(String componentId, int instanceId) {
        this.getAsso().put(componentId, Integer.toString(instanceId));
    }

    private void removeAsso(String componentId) {
        this.getAsso().remove(componentId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> loadAsso(Connection connection) throws ContentManagerException {
        boolean bCloseConnection = false;
        PreparedStatement prepStmt = null;
        ResultSet resSet = null;
        HashMap<String, String> tempAsso = new HashMap<String, String>();
        try {
            if (connection == null) {
                connection = DBUtil.makeConnection(m_dbName);
                bCloseConnection = true;
            }
            String sSQLStatement = "SELECT instanceId, componentId FROM " + m_sInstanceTable;
            SilverTrace.info("contentManager", "ContentManager.loadAsso", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement);
            resSet = prepStmt.executeQuery();
            while (resSet.next()) {
                tempAsso.put(resSet.getString(2), String.valueOf(resSet.getInt(1)));
            }
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("ContentManager.loadAsso", 4, "contentManager.EX_CANT_LOAD_ASSO_CACHE", "", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resSet, prepStmt);
                try {
                    if (!bCloseConnection) throw throwable;
                    if (connection == null) throw throwable;
                    connection.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    SilverTrace.error("contentManager", "ContentManager.loadAsso", "root.EX_CONNECTION_CLOSE_FAILED", "", e2);
                }
                throw throwable;
            }
        }
        DBUtil.close(resSet, prepStmt);
        try {
            if (!bCloseConnection) return tempAsso;
            if (connection == null) return tempAsso;
            connection.close();
            return tempAsso;
        }
        catch (Exception e) {
            SilverTrace.error("contentManager", "ContentManager.loadAsso", "root.EX_CONNECTION_CLOSE_FAILED", "", e);
            return tempAsso;
        }
    }

    public JoinStatement getPositionsByGenericSearch(String authorId, String afterDate, String beforeDate) throws ContentManagerException {
        StringBuilder sSQLStatement = new StringBuilder(1000);
        JoinStatement joinStatement = new JoinStatement();
        ArrayList<String> alGivenTables = new ArrayList<String>();
        ArrayList<String> alGivenKeys = new ArrayList<String>();
        alGivenTables.add(this.m_sSilverContentTable);
        alGivenKeys.add("silverContentId");
        joinStatement.setTables(alGivenTables);
        joinStatement.setJoinKeys(alGivenKeys);
        if (authorId != null && !authorId.equals("")) {
            sSQLStatement.append(" CMC.authorId = ").append(authorId);
        }
        if (beforeDate != null && beforeDate.length() > 0) {
            if (sSQLStatement.length() > 0) {
                sSQLStatement.append(" AND ");
            }
            sSQLStatement.append(" CMC.creationDate < ? ");
        }
        if (afterDate != null && afterDate.length() > 0) {
            if (sSQLStatement.length() > 0) {
                sSQLStatement.append(" AND ");
            }
            sSQLStatement.append(" CMC.creationDate > ? ");
        }
        joinStatement.setWhere(sSQLStatement.toString());
        return joinStatement;
    }

    public List<String> getInstanceId(List<Integer> alSilverContentId) throws ContentManagerException {
        ArrayList<String> arrayList;
        Connection connection = null;
        StringBuffer sSQLStatement = new StringBuffer();
        PreparedStatement prepStmt = null;
        ResultSet resSet = null;
        ArrayList<String> alInstanceIds = new ArrayList<String>();
        try {
            connection = DBUtil.makeConnection(m_dbName);
            sSQLStatement.append("select I.componentId from ").append(m_sInstanceTable).append(" I, ").append(this.m_sSilverContentTable).append(" C ");
            sSQLStatement.append(" where I.instanceId = C.contentInstanceId ");
            sSQLStatement.append(" and C.silverContentId = ?");
            prepStmt = connection.prepareStatement(sSQLStatement.toString());
            String instanceId = "";
            for (Integer oneSilverContentId : alSilverContentId) {
                prepStmt.setInt(1, oneSilverContentId);
                SilverTrace.info("contentManager", "ContentManager.getInstanceId", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement + " silverContentId=" + oneSilverContentId);
                resSet = prepStmt.executeQuery();
                if (resSet.next()) {
                    instanceId = resSet.getString(1);
                }
                if (!alInstanceIds.contains(instanceId)) {
                    alInstanceIds.add(instanceId);
                }
                DBUtil.close(resSet);
                resSet = null;
            }
            arrayList = alInstanceIds;
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("ContentManager.getInstanceId", 4, "contentManager.EX_CANT_GET_INSTANCEID", "", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resSet, prepStmt);
                this.closeConnection(connection);
                throw throwable;
            }
        }
        DBUtil.close(resSet, prepStmt);
        this.closeConnection(connection);
        return arrayList;
    }

    public List<Integer> getSilverContentIdByInstanceId(String instanceId) throws ContentManagerException {
        ArrayList<Integer> arrayList;
        Connection con = null;
        PreparedStatement prepStmt = null;
        ResultSet resSet = null;
        ArrayList<Integer> allSilverContentIds = new ArrayList<Integer>();
        try {
            con = DBUtil.makeConnection(m_dbName);
            String sSQLStatement = "select C.silverContentId from " + m_sInstanceTable + " I, " + this.m_sSilverContentTable + " C ";
            sSQLStatement = sSQLStatement + " where I.instanceId = C.contentInstanceId ";
            sSQLStatement = sSQLStatement + " and I.componentId like ? ";
            SilverTrace.info("contentManager", "ContentManager.getSilverContentIdByInstanceId", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement + " instranceId=" + instanceId);
            prepStmt = con.prepareStatement(sSQLStatement);
            prepStmt.setString(1, instanceId);
            resSet = prepStmt.executeQuery();
            while (resSet.next()) {
                allSilverContentIds.add(resSet.getInt(1));
            }
            arrayList = allSilverContentIds;
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("ContentManager.getSilverContentIdByInstanceId", 4, "contentManager.EX_CANT_GET_INSTANCEID", "", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resSet, prepStmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        DBUtil.close(resSet, prepStmt);
        this.closeConnection(con);
        return arrayList;
    }

    public List<SilverContent> getSilverContentBySilverContentIds(List<Integer> alSilverContentIds) throws ContentManagerException {
        ArrayList<SilverContent> arrayList;
        Connection con = null;
        PreparedStatement prepStmt = null;
        ResultSet resSet = null;
        ArrayList<SilverContent> silverContents = new ArrayList<SilverContent>();
        try {
            con = DBUtil.makeConnection(m_dbName);
            StringBuilder where = new StringBuilder();
            int sizeOfIds = alSilverContentIds.size();
            for (int i = 0; i < sizeOfIds - 1; ++i) {
                where.append(" silverContentId = ").append(alSilverContentIds.get(i).toString()).append(" or ");
            }
            if (sizeOfIds != 0) {
                where.append(" silverContentId = ").append(alSilverContentIds.get(sizeOfIds - 1).toString());
            }
            String sSQLStatement = "select silverContentName, silverContentDescription, silverContentUrl from " + this.m_sSilverContentTable;
            sSQLStatement = sSQLStatement + " where " + where.toString();
            SilverTrace.info("contentManager", "ContentManager.getSilverContentBySilverContentIds", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = con.prepareStatement(sSQLStatement);
            resSet = prepStmt.executeQuery();
            while (resSet.next()) {
                silverContents.add(new SilverContent(resSet.getString(1), resSet.getString(2), resSet.getString(3)));
            }
            arrayList = silverContents;
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("ContentManager.getSilverContentBySilverContentIds", 4, "contentManager.EX_CANT_GET_INSTANCEID", "", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resSet, prepStmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        DBUtil.close(resSet, prepStmt);
        this.closeConnection(con);
        return arrayList;
    }

    public void updateSilverContentVisibilityAttributes(SilverContentVisibility scv, String instanceId, int silverObjectId) throws ContentManagerException {
        Connection con = null;
        PreparedStatement prepStmt = null;
        try {
            if (scv != null) {
                con = DBUtil.makeConnection(m_dbName);
                StringBuffer sSQLStatement = new StringBuffer();
                sSQLStatement.append("UPDATE ").append(this.m_sSilverContentTable);
                sSQLStatement.append(" SET beginDate = ? , endDate = ? , isVisible = ? ");
                sSQLStatement.append(" WHERE silverContentId = ").append(silverObjectId);
                SilverTrace.info("contentManager", "ContentManager.updateSilverContentVisibilityAttributes", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
                prepStmt = con.prepareStatement(sSQLStatement.toString());
                prepStmt.setString(1, scv.getBeginDate());
                prepStmt.setString(2, scv.getEndDate());
                prepStmt.setInt(3, scv.isVisible());
                prepStmt.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new ContentManagerException("ContentManager.updateSilverContentVisibilityAttributes", 4, "contentManager.EX_CANT_UPDATE_SILVER_CONTENT", e);
        }
        finally {
            DBUtil.close(prepStmt);
            this.closeConnection(con);
        }
    }

    public SilverContentVisibility getSilverContentVisibility(int silverObjectId) throws ContentManagerException {
        Connection connection = null;
        StringBuffer sSQLStatement = new StringBuffer();
        PreparedStatement prepStmt = null;
        ResultSet resSet = null;
        SilverContentVisibility scv = null;
        try {
            connection = DBUtil.makeConnection(m_dbName);
            sSQLStatement.append("SELECT beginDate, endDate, isVisible FROM ").append(this.m_sSilverContentTable);
            sSQLStatement.append(" WHERE silverContentId = '").append(silverObjectId).append("'");
            SilverTrace.info("contentManager", "ContentManager.getSilverContentVisibility", "root.MSG_GEN_PARAM_VALUE", "sSQLStatement= " + sSQLStatement);
            prepStmt = connection.prepareStatement(sSQLStatement.toString());
            resSet = prepStmt.executeQuery();
            if (resSet.next()) {
                String beginDate = resSet.getString(1);
                String endDate = resSet.getString(2);
                int visibility = resSet.getInt(3);
                boolean isVisible = true;
                if (visibility == 0) {
                    isVisible = false;
                }
                scv = new SilverContentVisibility(beginDate, endDate, isVisible);
            }
        }
        catch (SQLException e) {
            try {
                throw new ContentManagerException("ContentManager.getSilverContentVisibility", 4, "contentManager.EX_CANT_QUERY_DATABASE", "sSQLStatement: " + sSQLStatement, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resSet, prepStmt);
                this.closeConnection(connection);
                throw throwable;
            }
        }
        DBUtil.close(resSet, prepStmt);
        this.closeConnection(connection);
        return scv;
    }

    static {
        ContentPeas contentFB = new ContentPeas("fileBoxPlus");
        ContentPeas contentWP = new ContentPeas("whitePages");
        ContentPeas contentQR = new ContentPeas("questionReply");
        ContentPeas contentKMelia = new ContentPeas("kmelia");
        ContentPeas contentSurvey = new ContentPeas("survey");
        ContentPeas contentToolbox = new ContentPeas("toolbox");
        ContentPeas contentQuickInfo = new ContentPeas("quickinfo");
        ContentPeas contentAlmanach = new ContentPeas("almanach");
        ContentPeas contentQuizz = new ContentPeas("quizz");
        ContentPeas contentForums = new ContentPeas("forums");
        ContentPeas contentPollingStation = new ContentPeas("pollingStation");
        ContentPeas contentBookmark = new ContentPeas("bookmark");
        ContentPeas contentChat = new ContentPeas("chat");
        ContentPeas contentInfoLetter = new ContentPeas("infoLetter");
        ContentPeas contentEL = new ContentPeas("expertLocator");
        ContentPeas contentWebSites = new ContentPeas("webSites");
        ContentPeas contentGallery = new ContentPeas("gallery");
        ContentPeas contentBlog = new ContentPeas("blog");
        s_acContentPeas.add(contentFB);
        s_acContentPeas.add(contentWP);
        s_acContentPeas.add(contentQR);
        s_acContentPeas.add(contentKMelia);
        s_acContentPeas.add(contentSurvey);
        s_acContentPeas.add(contentToolbox);
        s_acContentPeas.add(contentQuickInfo);
        s_acContentPeas.add(contentAlmanach);
        s_acContentPeas.add(contentQuizz);
        s_acContentPeas.add(contentForums);
        s_acContentPeas.add(contentPollingStation);
        s_acContentPeas.add(contentBookmark);
        s_acContentPeas.add(contentChat);
        s_acContentPeas.add(contentInfoLetter);
        s_acContentPeas.add(contentEL);
        s_acContentPeas.add(contentWebSites);
        s_acContentPeas.add(contentGallery);
        s_acContentPeas.add(contentBlog);
        assoComponentIdInstanceId = null;
        assoSilverContentIdInternalComponentId = new HashMap(1000);
        m_dbName = JNDINames.CONTENTMANAGER_DATASOURCE;
        m_sInstanceTable = "SB_ContentManager_Instance";
        try {
            assoComponentIdInstanceId = new HashMap<String, String>(ContentManager.loadAsso(null));
        }
        catch (ContentManagerException e) {
            SilverTrace.error("contentManager", "ContentManager.initStatic", "root.EX_CLASS_NOT_INITIALIZED", "assoComponentIdInstanceId initialization failed !", e);
        }
    }
}

