/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.ldapdriver;

import com.novell.ldap.LDAPEntry;
import com.stratelia.silverpeas.domains.ldapdriver.AbstractLDAPGroup;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPUtility;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import java.util.Vector;

public class LDAPGroupUniqueDescriptor
extends AbstractLDAPGroup {
    protected String[] getMemberGroupIds(String lds, String memberId, boolean isGroup) throws AdminException {
        Vector<String> groupsVector = new Vector<String>();
        LDAPEntry[] theEntries = null;
        LDAPEntry memberEntry = null;
        SilverTrace.info("admin", "LDAPGroupUniqueDescriptor.getMemberGroupIds()", "root.MSG_GEN_ENTER_METHOD", "MemberId=" + memberId + ", isGroup=" + isGroup);
        memberEntry = isGroup ? LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsIdFilter(memberId), this.driverSettings.getGroupAttributes()) : LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(memberId), this.driverSettings.getGroupAttributes());
        if (memberEntry == null) {
            throw new AdminException("LDAPGroupUniqueDescriptor.getMemberGroupIds", 4, "admin.EX_ERR_LDAP_USER_ENTRY_ISNULL", "Id=" + memberId + " IsGroup=" + isGroup);
        }
        theEntries = LDAPUtility.search1000Plus(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), "(&" + this.driverSettings.getGroupsFullFilter() + "(" + this.driverSettings.getGroupsMemberField() + "=" + LDAPUtility.dblBackSlashesForDNInFilters(memberEntry.getDN()) + "))", this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
        for (int i = 0; i < theEntries.length; ++i) {
            SilverTrace.info("admin", "LDAPGroupUniqueDescriptor.getMemberGroupIds()", "root.MSG_GEN_PARAM_VALUE", "GroupFound=" + theEntries[i].getDN());
            groupsVector.add(LDAPUtility.getFirstAttributeValue(theEntries[i], this.driverSettings.getGroupsIdField()));
        }
        return groupsVector.toArray(new String[groupsVector.size()]);
    }

    @Override
    public String[] getGroupMemberGroupIds(String lds, String groupId) throws AdminException {
        return this.getMemberGroupIds(lds, groupId, true);
    }

    @Override
    public String[] getUserMemberGroupIds(String lds, String userId) throws AdminException {
        return this.getMemberGroupIds(lds, userId, false);
    }

    @Override
    protected String[] getUserIds(String lds, LDAPEntry groupEntry) throws AdminException {
        Vector<String> usersVector = new Vector<String>();
        LDAPEntry userEntry = null;
        String[] stringVals = null;
        SilverTrace.info("admin", "LDAPGroupUniqueDescriptor.getUserIds()", "root.MSG_GEN_ENTER_METHOD");
        stringVals = LDAPUtility.getAttributeValues(groupEntry, this.driverSettings.getGroupsMemberField());
        for (int i = 0; i < stringVals.length; ++i) {
            try {
                userEntry = LDAPUtility.getFirstEntryFromSearch(lds, stringVals[i], this.driverSettings.getScope(), this.driverSettings.getUsersFullFilter(), this.driverSettings.getGroupAttributes());
                if (userEntry == null) continue;
                String userSpecificId = LDAPUtility.getFirstAttributeValue(userEntry, this.driverSettings.getUsersIdField());
                if (LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(userSpecificId), this.driverSettings.getGroupAttributes()) == null) continue;
                usersVector.add(userSpecificId);
                continue;
            }
            catch (AdminException e) {
                SilverTrace.error("admin", "LDAPGroupUniqueDescriptor.getUserIds()", "admin.MSG_ERR_LDAP_GENERAL", "USER NOT FOUND : " + LDAPUtility.dblBackSlashesForDNInFilters(stringVals[i]), e);
            }
        }
        stringVals = null;
        SilverTrace.info("admin", "LDAPGroupUniqueDescriptor.getUserIds()", "root.MSG_GEN_EXIT_METHOD");
        return usersVector.toArray(new String[usersVector.size()]);
    }

    @Override
    protected LDAPEntry[] getChildGroupsEntry(String lds, String parentId, String extraFilter) throws AdminException {
        Vector<LDAPEntry> entryVector;
        block12: {
            LDAPEntry theEntry = null;
            LDAPEntry childGroupEntry = null;
            LDAPEntry parentGroupEntry = null;
            entryVector = new Vector<LDAPEntry>();
            String[] stringVals = null;
            LDAPEntry[] theEntries = null;
            try {
                if (parentId != null && parentId.length() > 0) {
                    SilverTrace.info("admin", "LDAPGroupUniqueDescriptor.getChildGroupsEntry()", "root.MSG_GEN_PARAM_VALUE", "Root Group Search : " + parentId);
                    theEntry = this.getGroupEntry(lds, parentId);
                    stringVals = LDAPUtility.getAttributeValues(theEntry, this.driverSettings.getGroupsMemberField());
                    for (int i = 0; i < stringVals.length; ++i) {
                        try {
                            String theFilter = extraFilter != null && extraFilter.length() > 0 ? "(&" + extraFilter + this.driverSettings.getGroupsFullFilter() + ")" : this.driverSettings.getGroupsFullFilter();
                            childGroupEntry = LDAPUtility.getFirstEntryFromSearch(lds, stringVals[i], this.driverSettings.getScope(), theFilter, this.driverSettings.getGroupAttributes());
                            if (childGroupEntry == null) continue;
                            String groupSpecificId = LDAPUtility.getFirstAttributeValue(childGroupEntry, this.driverSettings.getGroupsIdField());
                            if (LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsIdFilter(groupSpecificId), this.driverSettings.getGroupAttributes()) == null) continue;
                            entryVector.add(childGroupEntry);
                            continue;
                        }
                        catch (AdminException e) {
                            SilverTrace.error("admin", "LDAPGroupUniqueDescriptor.getChildGroupsEntry()", "admin.MSG_ERR_LDAP_GENERAL", "GROUP NOT FOUND : " + stringVals[i], e);
                        }
                    }
                    break block12;
                }
                String theFilter = extraFilter != null && extraFilter.length() > 0 ? "(&" + extraFilter + this.driverSettings.getGroupsFullFilter() + ")" : this.driverSettings.getGroupsFullFilter();
                SilverTrace.info("admin", "LDAPGroupUniqueDescriptor.getChildGroupsEntry()", "root.MSG_GEN_PARAM_VALUE", "Root Group Search");
                theEntries = LDAPUtility.search1000Plus(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), theFilter, this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
                SynchroReport.debug("LDAPGroupUniqueDescriptor.getChildGroupsEntry()", "R\u00e9cup\u00e9ration de " + theEntries.length + " groupes en tout, recherche des groupes racine...", null);
                for (int i = 0; i < theEntries.length; ++i) {
                    try {
                        parentGroupEntry = LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), "(&" + this.driverSettings.getGroupsFullFilter() + "(" + this.driverSettings.getGroupsMemberField() + "=" + LDAPUtility.dblBackSlashesForDNInFilters(theEntries[i].getDN()) + "))", this.driverSettings.getGroupAttributes());
                    }
                    catch (AdminException e) {
                        SilverTrace.error("admin", "LDAPGroupUniqueDescriptor.getChildGroupsEntry()", "admin.MSG_ERR_LDAP_GENERAL", "IS ROOT GROUP ? : " + theEntries[i].getDN(), e);
                        parentGroupEntry = null;
                    }
                    if (parentGroupEntry != null) continue;
                    entryVector.add(theEntries[i]);
                }
                theEntries = null;
            }
            catch (AdminException e) {
                if (this.synchroInProcess) {
                    SilverTrace.warn("admin", "LDAPGroupUniqueDescriptor.getChildGroupsEntry()", "admin.EX_ERR_CHILD_GROUPS", "ParentGroupId=" + parentId, e);
                    this.append("PB getting Group's subgroups : ").append(parentId).append("\n");
                    if (parentId == null) {
                        SynchroReport.error("LDAPGroupUniqueDescriptor.getChildGroupsEntry()", "Erreur lors de la r\u00e9cup\u00e9ration des groupes racine", e);
                    } else {
                        SynchroReport.error("LDAPGroupUniqueDescriptor.getChildGroupsEntry()", "Erreur lors de la r\u00e9cup\u00e9ration des groupes fils du groupe " + parentId, e);
                    }
                }
                throw e;
            }
        }
        return entryVector.toArray(new LDAPEntry[entryVector.size()]);
    }
}

