/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.ldapdriver;

import com.novell.ldap.LDAPEntry;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPSettings;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPUtility;
import java.util.Hashtable;

public class LDAPSynchroCache {
    protected Hashtable userSpecificIds = null;
    protected LDAPSettings driverSettings = null;

    public void init(LDAPSettings driverSettings) {
        this.driverSettings = driverSettings;
    }

    public void beginSynchronization() {
        if (this.driverSettings.isSynchroCacheEnabled()) {
            this.userSpecificIds = new Hashtable();
        }
    }

    public void endSynchronization() {
        if (this.userSpecificIds != null) {
            this.userSpecificIds.clear();
            this.userSpecificIds = null;
        }
    }

    public void addUser(LDAPEntry userEntry) {
        if (this.userSpecificIds != null) {
            this.userSpecificIds.put(userEntry.getDN(), LDAPUtility.getFirstAttributeValue(userEntry, this.driverSettings.getUsersIdField()));
        }
    }

    public void addUser(String theDN, String theId) {
        if (this.userSpecificIds != null) {
            this.userSpecificIds.put(theDN, theId);
        }
    }

    public String getUserId(String theDN) {
        if (this.userSpecificIds != null) {
            return (String)this.userSpecificIds.get(theDN);
        }
        return null;
    }
}

